"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindCostSavingsPrompts = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindCostSavingsPrompts = payload => {
  const {
    data: {
      prompts = []
    }
  } = (0, _elasticAssistant.useFindPrompts)({
    ...payload,
    params: {
      prompt_group_id: 'aiForSoc',
      prompt_ids: ['costSavingsInsightPart1', 'costSavingsInsightPart2']
    }
  });
  return (0, _react.useMemo)(() => {
    var _prompts$find, _prompts$find2;
    const part1 = (_prompts$find = prompts.find(p => p.promptId === 'costSavingsInsightPart1')) === null || _prompts$find === void 0 ? void 0 : _prompts$find.prompt;
    const part2 = (_prompts$find2 = prompts.find(p => p.promptId === 'costSavingsInsightPart2')) === null || _prompts$find2 === void 0 ? void 0 : _prompts$find2.prompt;
    return part1 != null && part2 != null ? {
      part1,
      part2
    } : null;
  }, [prompts]);
};
exports.useFindCostSavingsPrompts = useFindCostSavingsPrompts;