"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserAlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../app/actions/constants");
var _use_navigate_to_alerts_page_with_filters = require("../../../../common/hooks/use_navigate_to_alerts_page_with_filters");
var _formatted_number = require("../../../../common/components/formatted_number");
var _header_section = require("../../../../common/components/header_section");
var _hover_visibility_container = require("../../../../common/components/hover_visibility_container");
var _inspect = require("../../../../common/components/inspect");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _links = require("../../../../common/components/links");
var _query_toggle = require("../../../../common/containers/query_toggle");
var i18n = _interopRequireWildcard(require("../translations"));
var _utils = require("../utils");
var _use_user_alerts_items = require("./use_user_alerts_items");
var _cell_actions = require("../../../../common/components/cell_actions");
var _use_global_filter_query = require("../../../../common/hooks/use_global_filter_query");
var _model = require("../../../../sourcerer/store/model");
var _risk_color_palette = require("../../../../common/utils/risk_color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/detection_response/user_alerts_table/user_alerts_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DETECTION_RESPONSE_USER_SEVERITY_QUERY_ID = 'vulnerableUsersBySeverityQuery';
const UserAlertsTable = exports.UserAlertsTable = /*#__PURE__*/_react.default.memo(({
  signalIndexName
}) => {
  const openAlertsPageWithFilters = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const openUserInAlerts = (0, _react.useCallback)(({
    userName,
    severity
  }) => openAlertsPageWithFilters([{
    title: i18n.OPEN_IN_ALERTS_TITLE_USERNAME,
    selectedOptions: [userName],
    fieldName: 'user.name'
  }, ...(severity ? [{
    title: i18n.OPEN_IN_ALERTS_TITLE_SEVERITY,
    selectedOptions: [severity],
    fieldName: _ruleDataUtils.ALERT_SEVERITY
  }] : [])]), [openAlertsPageWithFilters]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTION_RESPONSE_USER_SEVERITY_QUERY_ID);
  const {
    items,
    isLoading,
    updatedAt,
    pagination
  } = (0, _use_user_alerts_items.useUserAlertsItems)({
    skip: !toggleStatus,
    queryId: DETECTION_RESPONSE_USER_SEVERITY_QUERY_ID,
    signalIndexName,
    filterQuery
  });
  const columns = useGetTableColumns(openUserInAlerts);
  return /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: true,
    targetClassNames: [_inspect.BUTTON_CLASS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "severityUserAlertsPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: DETECTION_RESPONSE_USER_SEVERITY_QUERY_ID,
    title: i18n.USER_ALERTS_SECTION_TITLE,
    titleSize: "s",
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: updatedAt,
      isUpdating: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 21
      }
    }),
    tooltip: i18n.USER_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "severityUserAlertsTable",
    columns: columns,
    items: items,
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 40
        }
      }, i18n.NO_ALERTS_FOUND),
      titleSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }), pagination.pageCount > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    "data-test-subj": "userTablePaginator",
    activePage: pagination.currentPage,
    itemsPerPage: _utils.ITEMS_PER_PAGE,
    pageCount: pagination.pageCount,
    onChangePage: pagination.setPage,
    showPerPageOptions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }))));
});
UserAlertsTable.displayName = 'UserAlertsTable';
const useGetTableColumns = handleClick => {
  const severityColors = (0, _risk_color_palette.useRiskSeverityColors)();
  return (0, _react.useMemo)(() => [{
    field: 'userName',
    name: i18n.USER_ALERTS_USERNAME_COLUMN,
    'data-test-subj': 'userSeverityAlertsTable-userName',
    render: userName => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: i18n.OPEN_USER_DETAIL_TOOLTIP,
      content: userName,
      anchorClassName: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_links.UserDetailsLink, {
      userName: userName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 13
      }
    }))
  }, {
    field: 'totalAlerts',
    name: i18n.ALERTS_TEXT,
    'data-test-subj': 'userSeverityAlertsTable-totalAlerts',
    render: (totalAlerts, {
      userName
    }) => /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: userName,
        field: 'user.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "userSeverityAlertsTable-totalAlertsLink",
      disabled: totalAlerts === 0,
      onClick: () => handleClick({
        userName
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: totalAlerts,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 15
      }
    })))
  }, {
    field: 'critical',
    name: i18n.STATUS_CRITICAL_LABEL,
    render: (count, {
      userName
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": "userSeverityAlertsTable-critical",
      color: severityColors.critical,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 11
      }
    }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: userName,
        field: 'user.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.severity',
          value: 'critical'
        }, {
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "userSeverityAlertsTable-criticalLink",
      onClick: () => handleClick({
        userName,
        severity: 'critical'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 15
      }
    }))
  }, {
    field: 'high',
    name: i18n.STATUS_HIGH_LABEL,
    render: (count, {
      userName
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": "userSeverityAlertsTable-high",
      color: severityColors.high,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 11
      }
    }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: userName,
        field: 'user.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.severity',
          value: 'high'
        }, {
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => handleClick({
        userName,
        severity: 'high'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 15
      }
    }))
  }, {
    field: 'medium',
    name: i18n.STATUS_MEDIUM_LABEL,
    render: (count, {
      userName
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": "userSeverityAlertsTable-medium",
      color: severityColors.medium,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 11
      }
    }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: userName,
        field: 'user.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.severity',
          value: 'medium'
        }, {
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => handleClick({
        userName,
        severity: 'medium'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 15
      }
    }))
  }, {
    field: 'low',
    name: i18n.STATUS_LOW_LABEL,
    render: (count, {
      userName
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      "data-test-subj": "userSeverityAlertsTable-low",
      color: severityColors.low,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 11
      }
    }, count > 0 ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: userName,
        field: 'user.name'
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.severity',
          value: 'low'
        }, {
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => handleClick({
        userName,
        severity: 'low'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: count,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 15
      }
    }))
  }], [handleClick, severityColors]);
};