"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseItems = void 0;
var _react = require("react");
var _uuid = require("uuid");
var _constants = require("../../../../../common/constants");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _kibana = require("../../../../common/lib/kibana");
var _actions = require("../../../../common/store/app/actions");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCaseItems = ({
  skip
}) => {
  const {
    services: {
      cases
    }
  } = (0, _kibana.useKibana)();
  const {
    to,
    from,
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const [items, setItems] = (0, _react.useState)([]);
  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `useCaseItems-${(0, _uuid.v4)()}`, []);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    const fetchCases = async () => {
      try {
        const casesResponse = await cases.api.cases.find({
          from,
          to,
          owner: _constants.APP_ID,
          sortField: 'createdAt',
          sortOrder: 'desc',
          page: 1,
          perPage: 4
        });
        if (isSubscribed) {
          setItems(parseCases(casesResponse));
          setUpdatedAt(Date.now());
        }
      } catch (error) {
        if (isSubscribed) {
          (0, _actions.addError)(error, {
            title: i18n.ERROR_MESSAGE_CASES
          });
        }
      }
      setIsLoading(false);
    };
    if (!skip) {
      fetchCases();
      setQuery({
        id: uniqueQueryId,
        inspect: null,
        loading: false,
        refetch: fetchCases
      });
    }
    if (skip) {
      setIsLoading(false);
      isSubscribed = false;
      abortCtrl.abort();
    }
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
      deleteQuery({
        id: uniqueQueryId
      });
    };
  }, [cases.api.cases, from, skip, to, setQuery, deleteQuery, uniqueQueryId]);
  return {
    items,
    isLoading,
    updatedAt
  };
};
exports.useCaseItems = useCaseItems;
function parseCases(casesResponse) {
  const allCases = casesResponse.cases || [];
  return allCases.reduce((accumulated, currentCase) => {
    accumulated.push({
      id: currentCase.id,
      name: currentCase.title,
      totalAlerts: currentCase.totalAlerts,
      createdAt: currentCase.createdAt,
      createdBy: currentCase.createdBy.username || '—',
      status: currentCase.status
    });
    return accumulated;
  }, []);
}