"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectionSettingCardSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _use_license = require("../../../../../../common/hooks/use_license");
var _types = require("../../../../../../../common/endpoint/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/protection_setting_card_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProtectionSettingCardSwitch = exports.ProtectionSettingCardSwitch = /*#__PURE__*/_react.default.memo(({
  protection,
  protectionLabel,
  osList,
  additionalOnSwitchChange,
  onChange,
  policy,
  mode,
  selected,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const isEditMode = mode === 'edit';
  const handleSwitchChange = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    if (event.target.checked === false) {
      for (const os of osList) {
        if (os === 'windows') {
          newPayload[os][protection].mode = _types.ProtectionModes.off;
        } else if (os === 'mac') {
          newPayload[os][protection].mode = _types.ProtectionModes.off;
        } else if (os === 'linux') {
          newPayload[os][protection].mode = _types.ProtectionModes.off;
        }
        if (isPlatinumPlus) {
          if (os === 'windows') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          } else if (os === 'mac') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          } else if (os === 'linux') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          }
          if (protection === 'behavior_protection') {
            newPayload.windows.behavior_protection.reputation_service = false;
            newPayload.mac.behavior_protection.reputation_service = false;
            newPayload.linux.behavior_protection.reputation_service = false;
          }
        }
      }
    } else {
      for (const os of osList) {
        if (os === 'windows') {
          newPayload[os][protection].mode = _types.ProtectionModes.prevent;
        } else if (os === 'mac') {
          newPayload[os][protection].mode = _types.ProtectionModes.prevent;
        } else if (os === 'linux') {
          newPayload[os][protection].mode = _types.ProtectionModes.prevent;
        }
        if (isPlatinumPlus) {
          if (protection === 'behavior_protection') {
            newPayload.windows.behavior_protection.reputation_service = true;
            newPayload.mac.behavior_protection.reputation_service = true;
            newPayload.linux.behavior_protection.reputation_service = true;
          }
          if (os === 'windows') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          } else if (os === 'mac') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          } else if (os === 'linux') {
            newPayload[os].popup[protection].enabled = event.target.checked;
          }
        }
      }
    }
    onChange({
      isValid: true,
      updatedPolicy: additionalOnSwitchChange ? additionalOnSwitchChange({
        value: event.target.checked,
        policyConfigData: newPayload,
        protectionOsList: osList
      }) : newPayload
    });
  }, [policy, onChange, additionalOnSwitchChange, osList, isPlatinumPlus, protection]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: protectionLabel,
    labelProps: {
      'data-test-subj': getTestId('label')
    },
    checked: selected,
    disabled: !isEditMode,
    onChange: handleSwitchChange,
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  });
});
ProtectionSettingCardSwitch.displayName = 'ProtectionSettingCardSwitch';