"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_bulk_fetch_fleet_integration_policies = require("../../../../../hooks/policy/use_bulk_fetch_fleet_integration_policies");
var _kibana = require("../../../../../../common/lib/kibana");
var _constants = require("../../../../../../../common/constants");
var _search_exceptions = require("../../../../../components/search_exceptions");
var _use_endpoint_policies_to_artifact_policies = require("../../../../../components/artifact_entry_card/hooks/use_endpoint_policies_to_artifact_policies");
var _use_url_params = require("../../../../../hooks/use_url_params");
var _use_url_pagination = require("../../../../../hooks/use_url_pagination");
var _use_old_url_search_pagination_replace = require("../../../../../hooks/use_old_url_search_pagination_replace");
var _artifact_card_grid = require("../../../../../components/artifact_card_grid");
var _policy_hooks = require("../../policy_hooks");
var _artifacts = require("../../../../../../../common/endpoint/service/artifacts");
var _user_privileges = require("../../../../../../common/components/user_privileges");
var _use_policy_artifacts_empty_hooks = require("../empty/use_policy_artifacts_empty_hooks");
var _artifacts2 = require("../../../../../hooks/artifacts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/artifacts/list/policy_artifacts_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyArtifactsList = exports.PolicyArtifactsList = /*#__PURE__*/_react.default.memo(({
  policy,
  apiClient,
  searchableFields,
  getArtifactPath,
  getPolicyArtifactsPath,
  labels,
  onDeleteActionCallback,
  canWriteArtifact = false,
  CardDecorator
}) => {
  var _policiesRequest$data;
  (0, _use_old_url_search_pagination_replace.useOldUrlSearchPaginationReplace)();
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const {
    canCreateArtifactsByPolicy
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const navigateCallback = (0, _policy_hooks.usePolicyDetailsArtifactsNavigateCallback)(apiClient.listId);
  const {
    urlParams
  } = (0, _use_url_params.useUrlParams)();
  const [expandedItemsMap, setExpandedItemsMap] = (0, _react.useState)(new Map());
  const {
    state
  } = (0, _use_policy_artifacts_empty_hooks.useGetLinkTo)(policy.id, policy.name, getPolicyArtifactsPath, getArtifactPath);
  const {
    pageSizeOptions,
    pagination: urlPagination,
    setPagination
  } = (0, _use_url_pagination.useUrlPagination)();
  const {
    data: artifacts,
    isLoading: isLoadingArtifacts,
    isRefetching: isRefetchingArtifacts
  } = (0, _artifacts2.useListArtifact)(apiClient, {
    page: urlPagination.page,
    perPage: urlPagination.pageSize,
    filter: urlParams.filter,
    policies: [policy.id, 'all']
  }, searchableFields);
  const allArtifactReferencedPolicyIds = (0, _react.useMemo)(() => {
    const ids = new Set();
    if (artifacts !== null && artifacts !== void 0 && artifacts.data) {
      for (const artifact of artifacts.data) {
        (0, _artifacts.getPolicyIdsFromArtifact)(artifact).forEach(policyId => ids.add(policyId));
      }
    }
    return Array.from(ids);
  }, [artifacts === null || artifacts === void 0 ? void 0 : artifacts.data]);
  const policiesRequest = (0, _use_bulk_fetch_fleet_integration_policies.useBulkFetchFleetIntegrationPolicies)({
    ids: allArtifactReferencedPolicyIds
  }, {
    enabled: allArtifactReferencedPolicyIds.length > 0,
    keepPreviousData: false
  });
  const pagination = (0, _react.useMemo)(() => ({
    pageSize: urlPagination.pageSize,
    pageIndex: urlPagination.page - 1,
    pageSizeOptions,
    totalItemCount: (artifacts === null || artifacts === void 0 ? void 0 : artifacts.total) || 0
  }), [artifacts === null || artifacts === void 0 ? void 0 : artifacts.total, pageSizeOptions, urlPagination.page, urlPagination.pageSize]);
  const handleOnSearch = (0, _react.useCallback)(filter => {
    navigateCallback({
      filter
    });
  }, [navigateCallback]);
  const handleOnExpandCollapse = (0, _react.useCallback)(({
    expanded,
    collapsed
  }) => {
    const newExpandedMap = new Map(expandedItemsMap);
    for (const item of expanded) {
      newExpandedMap.set(item.id, true);
    }
    for (const item of collapsed) {
      newExpandedMap.set(item.id, false);
    }
    setExpandedItemsMap(newExpandedMap);
  }, [expandedItemsMap]);
  const handleOnPageChange = (0, _react.useCallback)(({
    pageIndex,
    pageSize
  }) => {
    if (artifacts !== null && artifacts !== void 0 && artifacts.total) setPagination({
      page: pageIndex + 1,
      pageSize
    });
  }, [artifacts === null || artifacts === void 0 ? void 0 : artifacts.total, setPagination]);
  const totalItemsCountLabel = (0, _react.useMemo)(() => {
    return labels.listTotalItemCountMessage((artifacts === null || artifacts === void 0 ? void 0 : artifacts.data.length) || 0);
  }, [artifacts === null || artifacts === void 0 ? void 0 : artifacts.data.length, labels]);
  const artifactCardPolicies = (0, _use_endpoint_policies_to_artifact_policies.useEndpointPoliciesToArtifactPolicies)((_policiesRequest$data = policiesRequest.data) === null || _policiesRequest$data === void 0 ? void 0 : _policiesRequest$data.items);
  const provideCardProps = (0, _react.useCallback)(artifact => {
    const viewUrlPath = getArtifactPath({
      filter: artifact.item_id
    });
    const fullDetailsAction = {
      icon: 'controlsHorizontal',
      children: labels.listFullDetailsActionTitle,
      href: getAppUrl({
        appId: _constants.APP_UI_ID,
        path: viewUrlPath
      }),
      navigateAppId: _constants.APP_UI_ID,
      navigateOptions: {
        path: viewUrlPath,
        state
      },
      'data-test-subj': 'view-full-details-action'
    };
    const item = artifact;
    const isGlobal = (0, _artifacts.isArtifactGlobal)(item);
    const deleteAction = {
      icon: 'trash',
      children: labels.listRemoveActionTitle,
      onClick: () => {
        onDeleteActionCallback(item);
      },
      disabled: isGlobal,
      toolTipContent: isGlobal ? labels.listRemoveActionNotAllowedMessage : undefined,
      toolTipProps: {
        position: 'top'
      },
      'data-test-subj': 'remove-from-policy-action'
    };
    return {
      expanded: expandedItemsMap.get(item.id) || false,
      actions: canCreateArtifactsByPolicy && canWriteArtifact ? [fullDetailsAction, deleteAction] : [fullDetailsAction],
      policies: artifactCardPolicies
    };
  }, [artifactCardPolicies, canCreateArtifactsByPolicy, expandedItemsMap, canWriteArtifact, getAppUrl, getArtifactPath, labels.listFullDetailsActionTitle, labels.listRemoveActionNotAllowedMessage, labels.listRemoveActionTitle, onDeleteActionCallback, state]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_exceptions.SearchExceptions, {
    placeholder: labels.listSearchPlaceholderMessage,
    defaultValue: urlParams.filter,
    hideRefreshButton: true,
    onSearch: handleOnSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "policyDetailsArtifactsSearchCount",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, totalItemsCountLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_artifact_card_grid.ArtifactCardGrid, {
    items: (artifacts === null || artifacts === void 0 ? void 0 : artifacts.data) || [],
    onPageChange: handleOnPageChange,
    onExpandCollapse: handleOnExpandCollapse,
    cardComponentProps: provideCardProps,
    pagination: artifacts ? pagination : undefined,
    loading: isLoadingArtifacts || isRefetchingArtifacts,
    "data-test-subj": 'artifacts-collapsed-list',
    CardDecorator: CardDecorator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }));
});
PolicyArtifactsList.displayName = 'PolicyArtifactsList';