"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnknownCommand = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _unsupported_message_callout = require("./unsupported_message_callout");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _console_code_block = require("./console_code_block");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/unknown_comand.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UnknownCommand = exports.UnknownCommand = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStatus
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  const message = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.unknownCommand.helpMessage",
      defaultMessage: "The text you entered {userInput} is unsupported! Click {helpIcon} {boldHelp} or type {helpCmd} for assistance.",
      values: {
        userInput: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          bold: true,
          inline: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 28,
            columnNumber: 15
          }
        }, command.input),
        helpIcon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "question",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 32,
            columnNumber: 23
          }
        }),
        helpCmd: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
          bold: true,
          inline: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 34,
            columnNumber: 15
          }
        }, 'help'),
        boldHelp: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 39,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.console.unknownCommand.helpMessage.help",
          defaultMessage: "Help",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 40,
            columnNumber: 17
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    }));
  }, [command.input]);
  (0, _react.useEffect)(() => {
    setStatus('success');
  }, [setStatus]);
  return /*#__PURE__*/_react.default.createElement(_unsupported_message_callout.UnsupportedMessageCallout, {
    header: /*#__PURE__*/_react.default.createElement(_console_code_block.ConsoleCodeBlock, {
      textColor: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.console.unknownCommand.title",
      defaultMessage: "Unsupported text/command",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    })),
    "data-test-subj": getTestId('unknownCommandError'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, message);
});
UnknownCommand.displayName = 'UnknownCommand';