"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _classnames = _interopRequireDefault(require("classnames"));
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/console_manager/components/page_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EuiPanelStyled = (0, _styledComponents.default)(_eui.EuiPanel)`
  &.full-height,
  .full-height {
    height: 100%;
  }

  .is-not-scrollable {
    overflow: hidden;
  }

  .is-scrollable {
    overflow: auto;
  }
`;
const PageLayout = exports.PageLayout = /*#__PURE__*/(0, _react.memo)(({
  pageTitle,
  pageDescription,
  pageBody,
  actions,
  headerHasBottomBorder,
  restrictWidth,
  paddingSize = 'l',
  scrollableBody = false,
  headerBackComponent,
  children,
  'data-test-subj': dataTestSubj
}) => {
  const hideHeader = !pageTitle && !pageDescription && !actions && !headerBackComponent;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const headerRightSideItems = (0, _react.useMemo)(() => {
    return Array.isArray(actions) ? actions : actions ? [actions] : undefined;
  }, [actions]);
  const headerRightSideGroupProps = (0, _react.useMemo)(() => {
    return {
      gutterSize: 's'
    };
  }, []);
  const consoleBodyClassName = (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      'is-scrollable': scrollableBody,
      'is-not-scrollable': !scrollableBody,
      'full-height': true
    });
  }, [scrollableBody]);
  const headerTitleContainer = (0, _react.useMemo)(() => {
    return hideHeader ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      alignItems: "flexStart",
      wrap: false,
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, headerBackComponent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 35
      }
    }, headerBackComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": getTestId('titleHolder'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 15
      }
    }, pageTitle))));
  }, [getTestId, headerBackComponent, hideHeader, pageTitle]);
  return /*#__PURE__*/_react.default.createElement(EuiPanelStyled, {
    hasShadow: false,
    paddingSize: paddingSize,
    "data-test-subj": dataTestSubj,
    className: "full-height",
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "none",
    className: "full-height",
    "data-test-subj": getTestId('root'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, !hideHeader && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('headerContainer'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: headerTitleContainer,
    description: pageDescription,
    bottomBorder: headerHasBottomBorder,
    rightSideItems: headerRightSideItems,
    rightSideGroupProps: headerRightSideGroupProps,
    restrictWidth: restrictWidth,
    alignItems: "bottom",
    "data-test-subj": getTestId('header'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, pageBody), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: consoleBodyClassName,
    "data-test-subj": getTestId('consoleBody'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "main",
    className: "full-height",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, children))));
});
PageLayout.displayName = 'PageLayout';