"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDocumentDetailsContext = exports.DocumentDetailsProvider = exports.DocumentDetailsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_event_details = require("./hooks/use_event_details");
var _flyout_error = require("../../shared/components/flyout_error");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _use_basic_data_from_details_data = require("./hooks/use_basic_data_from_details_data");
var _use_rule_with_fallback = require("../../../detection_engine/rule_management/logic/use_rule_with_fallback");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/shared/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A context provider shared by the right, left and preview panels in expandable document details flyout
 */
const DocumentDetailsContext = exports.DocumentDetailsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const DocumentDetailsProvider = exports.DocumentDetailsProvider = /*#__PURE__*/(0, _react.memo)(({
  id,
  indexName,
  scopeId,
  jumpToEntityId,
  jumpToCursor,
  isPreviewMode,
  children
}) => {
  const {
    browserFields,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    getFieldsData,
    loading,
    refetchFlyoutData,
    searchHit
  } = (0, _use_event_details.useEventDetails)({
    eventId: id,
    indexName
  });
  const {
    ruleId
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    rule: maybeRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const contextValue = (0, _react.useMemo)(() => {
    var _maybeRule$investigat, _maybeRule$investigat2;
    return id && indexName && scopeId && dataAsNestedObject && dataFormattedForFieldBrowser && searchHit ? {
      eventId: id,
      indexName,
      scopeId,
      browserFields,
      dataAsNestedObject,
      dataFormattedForFieldBrowser,
      searchHit,
      investigationFields: (_maybeRule$investigat = maybeRule === null || maybeRule === void 0 ? void 0 : (_maybeRule$investigat2 = maybeRule.investigation_fields) === null || _maybeRule$investigat2 === void 0 ? void 0 : _maybeRule$investigat2.field_names) !== null && _maybeRule$investigat !== void 0 ? _maybeRule$investigat : [],
      refetchFlyoutData,
      getFieldsData,
      isRulePreview: scopeId === _securitysolutionDataTable.TableId.rulePreview,
      isPreviewMode: Boolean(isPreviewMode),
      jumpToEntityId,
      jumpToCursor
    } : undefined;
  }, [browserFields, dataAsNestedObject, dataFormattedForFieldBrowser, getFieldsData, id, indexName, isPreviewMode, jumpToCursor, jumpToEntityId, refetchFlyoutData, scopeId, searchHit, maybeRule]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 14
      }
    });
  }
  if (!contextValue) {
    return /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(DocumentDetailsContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, children);
});
DocumentDetailsProvider.displayName = 'DocumentDetailsProvider';
const useDocumentDetailsContext = () => {
  const contextValue = (0, _react.useContext)(DocumentDetailsContext);
  if (!contextValue) {
    throw new Error('DocumentDetailsContext can only be used within DocumentDetailsContext provider');
  }
  return contextValue;
};
exports.useDocumentDetailsContext = useDocumentDetailsContext;