"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotesDetails = exports.NO_NOTES = exports.FETCH_NOTES_ERROR = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_basic_data_from_details_data = require("../../shared/hooks/use_basic_data_from_details_data");
var _flyouts = require("../../shared/constants/flyouts");
var _store = require("../../../../timelines/store");
var _types = require("../../../../../common/types");
var _attach_to_active_timeline = require("./attach_to_active_timeline");
var _add_note = require("../../../../notes/components/add_note");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _test_ids = require("../../../../notes/components/test_ids");
var _notes_list = require("../../../../notes/components/notes_list");
var _actions = require("../../../../timelines/store/actions");
var _timeline = require("../../../../../common/api/timeline");
var _notes = require("../../../../notes/store/notes.slice");
var _context = require("../../shared/context");
var _user_privileges = require("../../../../common/components/user_privileges");
var _use_which_flyout = require("../../shared/hooks/use_which_flyout");
var _investigation_guide_view = require("./investigation_guide_view");
var _use_investigation_guide = require("../../shared/hooks/use_investigation_guide");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/notes_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FETCH_NOTES_ERROR = exports.FETCH_NOTES_ERROR = _i18n.i18n.translate('xpack.securitySolution.flyout.left.notes.fetchNotesErrorLabel', {
  defaultMessage: 'Error fetching notes'
});
const NO_NOTES = isAlert => _i18n.i18n.translate('xpack.securitySolution.flyout.left.notes.noNotesLabel', {
  defaultMessage: 'No notes have been created for this {value}.',
  values: {
    value: isAlert ? 'alert' : 'event'
  }
});

/**
 * List all the notes for a document id and allows to create new notes associated with that document.
 * Displayed in the document details expandable flyout left section.
 */
exports.NO_NOTES = NO_NOTES;
const NotesDetails = exports.NotesDetails = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    addError: addErrorToast
  } = (0, _use_app_toasts.useAppToasts)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    eventId,
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();
  const {
    notesPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    basicAlertData: basicData
  } = (0, _use_investigation_guide.useInvestigationGuide)({
    dataFormattedForFieldBrowser
  });
  const canCreateNotes = notesPrivileges.crud;

  // will drive the value we send to the AddNote component
  // if true (timeline is saved and the user kept the checkbox checked) we'll send the timelineId to the AddNote component
  // if false (timeline is not saved or the user unchecked the checkbox manually ) we'll send an empty string
  const [attachToTimeline, setAttachToTimeline] = (0, _react.useState)(true);

  // if the flyout is open from a timeline and that timeline is saved, we automatically check the checkbox to associate the note to it
  const isTimelineFlyout = (0, _use_which_flyout.useWhichFlyout)() === _flyouts.Flyouts.timeline;
  const timeline = (0, _reactRedux.useSelector)(state => _store.timelineSelectors.selectTimelineById(state, _types.TimelineId.active));
  const timelineSavedObjectId = (0, _react.useMemo)(() => {
    var _timeline$savedObject;
    return (_timeline$savedObject = timeline.savedObjectId) !== null && _timeline$savedObject !== void 0 ? _timeline$savedObject : '';
  }, [timeline.savedObjectId]);
  const isTimelineSaved = (0, _react.useMemo)(() => timeline.status === _timeline.TimelineStatusEnum.active, [timeline.status]);

  // Automatically pin an associated event if it's attached to a timeline and it's not pinned yet
  const onNoteAddInTimeline = (0, _react.useCallback)(() => {
    const isEventPinned = eventId ? (timeline === null || timeline === void 0 ? void 0 : timeline.pinnedEventIds[eventId]) === true : false;
    if (!isEventPinned && eventId && timelineSavedObjectId) {
      dispatch((0, _actions.pinEvent)({
        id: _types.TimelineId.active,
        eventId
      }));
    }
  }, [dispatch, eventId, timelineSavedObjectId, timeline.pinnedEventIds]);
  const selectNotesByDocumentId = (0, _react.useMemo)(() => (0, _notes.makeSelectNotesByDocumentId)(), []);
  const notes = (0, _reactRedux.useSelector)(state => selectNotesByDocumentId(state, eventId));
  const fetchStatus = (0, _reactRedux.useSelector)(state => (0, _notes.selectFetchNotesByDocumentIdsStatus)(state));
  const fetchError = (0, _reactRedux.useSelector)(state => (0, _notes.selectFetchNotesByDocumentIdsError)(state));
  const fetchNotes = (0, _react.useCallback)(() => dispatch((0, _notes.fetchNotesByDocumentIds)({
    documentIds: [eventId]
  })), [dispatch, eventId]);
  (0, _react.useEffect)(() => {
    fetchNotes();
  }, [fetchNotes]);

  // show a toast if the fetch notes call fails
  (0, _react.useEffect)(() => {
    if (fetchStatus === _notes.ReqStatus.Failed && fetchError) {
      addErrorToast(null, {
        title: FETCH_NOTES_ERROR
      });
    }
  }, [addErrorToast, fetchError, fetchStatus]);
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const noNotesMessage = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, NO_NOTES(isAlert)))), [isAlert]);
  return /*#__PURE__*/_react.default.createElement(_investigation_guide_view.BasicAlertDataContext.Provider, {
    value: basicData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, fetchStatus === _notes.ReqStatus.Loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
    "data-test-subj": _test_ids.NOTES_LOADING_TEST_ID,
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), fetchStatus === _notes.ReqStatus.Succeeded && notes.length === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, noNotesMessage) : /*#__PURE__*/_react.default.createElement(_notes_list.NotesList, {
    notes: notes,
    options: {
      hideFlyoutIcon: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }), canCreateNotes && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_add_note.AddNote, {
    eventId: eventId,
    timelineId: isTimelineFlyout && attachToTimeline ? timelineSavedObjectId : '',
    onNoteAdd: isTimelineFlyout && attachToTimeline ? onNoteAddInTimeline : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, isTimelineFlyout && /*#__PURE__*/_react.default.createElement(_attach_to_active_timeline.AttachToActiveTimeline, {
    setAttachToTimeline: setAttachToTimeline,
    isCheckboxDisabled: !isTimelineSaved,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }))));
});
NotesDetails.displayName = 'NotesDetails';