"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Users = void 0;
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/timelines-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _common2 = require("@kbn/timelines-plugin/common");
var _constants = require("../../../data_view_manager/constants");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _constants2 = require("../../../common/store/inputs/constants");
var _types = require("../../../app/types");
var _filters_global = require("../../../common/components/filters_global");
var _header_page = require("../../../common/components/header_page");
var _tab_navigation = require("../../../common/components/navigation/tab_navigation");
var _search_bar = require("../../../common/components/search_bar");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _last_event_time = require("../../../common/components/last_event_time");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _use_global_time = require("../../../common/containers/use_global_time");
var _kibana = require("../../../common/lib/kibana");
var _kuery = require("../../../common/lib/kuery");
var _store = require("../../../common/store");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _users_tabs = require("./users_tabs");
var _nav_tabs = require("./nav_tabs");
var i18n = _interopRequireWildcard(require("./translations"));
var _store2 = require("../store");
var _helpers = require("../../../timelines/components/timeline/helpers");
var _containers = require("../../../sourcerer/containers");
var _use_selector = require("../../../common/hooks/use_selector");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _kpi_users = require("../components/kpi_users");
var _types2 = require("../../../../common/entity_analytics/types");
var _helpers2 = require("../../hosts/store/helpers");
var _model = require("../store/model");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _empty_prompt = require("../../../common/components/empty_prompt");
var _helpers3 = require("./details/helpers");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../data_view_manager/hooks/use_selected_patterns");
var _page_loader = require("../../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/users/pages/users.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ID = 'UsersQueryId';

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styled.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
const UsersComponent = () => {
  const containerElement = (0, _react.useRef)(null);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const getUserRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store2.usersSelectors.userRiskScoreSeverityFilterSelector(), []);
  const severitySelection = (0, _use_selector.useDeepEqualSelector)(state => getUserRiskScoreFilterQuerySelector(state));
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const tabsFilters = _react.default.useMemo(() => {
    if (tabName === _model.UsersTableType.events) {
      return [...globalFilters, ..._helpers3.userNameExistsFilter];
    }
    if (tabName === _model.UsersTableType.risk) {
      const severityFilter = (0, _helpers2.generateSeverityFilter)(severitySelection, _types2.EntityType.user);
      return [...severityFilter, ...globalFilters];
    }
    return globalFilters;
  }, [severitySelection, tabName, globalFilters]);
  const {
    indicesExist: oldIndicesExist,
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_constants.DataViewManagerScopeName.explore);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.DataViewManagerScopeName.explore);
  const indicesExist = newDataViewPickerEnabled ? experimentalDataView.hasMatchedIndices() : oldIndicesExist;
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const [globalFiltersQuery, kqlError] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec: oldSourcererDataView,
    dataView: experimentalDataView,
    queries: [query],
    filters: globalFilters
  }), [uiSettings, oldSourcererDataView, experimentalDataView, query, globalFilters]);
  const [tabsFilterQuery] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec: oldSourcererDataView,
    dataView: experimentalDataView,
    queries: [query],
    filters: tabsFilters
  }), [experimentalDataView, oldSourcererDataView, query, tabsFilters, uiSettings]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: ID,
    filterQuery: globalFiltersQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur, _containerElement$cur2;
    (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : (_containerElement$cur2 = _containerElement$cur.querySelector('.inspectButtonComponent:last-of-type')) === null || _containerElement$cur2 === void 0 ? void 0 : _containerElement$cur2.focus();
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const navTabs = (0, _react.useMemo)(() => (0, _nav_tabs.navTabsUsers)((0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities)), [capabilities]);
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    onKeyDown: onKeyDown,
    ref: containerElement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    sourcererDataView: newDataViewPickerEnabled ? experimentalDataView : oldSourcererDataView,
    id: _constants2.InputsModelId.global,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _common2.LastEventIndexKey.users,
      indexNames: selectedPatterns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 17
      }
    }),
    border: true,
    title: i18n.PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_kpi_users.UsersKpiComponent, {
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: navTabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_users_tabs.UsersTabs, {
    deleteQuery: deleteQuery,
    filterQuery: tabsFilterQuery,
    from: from,
    indexNames: selectedPatterns,
    isInitializing: isInitializing,
    setQuery: setQuery,
    to: to,
    type: _store2.usersModel.UsersType.page,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.users,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 7
    }
  }));
};
UsersComponent.displayName = 'UsersComponent';
const Users = exports.Users = /*#__PURE__*/_react.default.memo(UsersComponent);