"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricEmbeddable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../data_view_manager/constants");
var _utils = require("./utils");
var _visualization_embeddable = require("../../../common/components/visualization_actions/visualization_embeddable");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/components/stat_items/metric_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CHART_HEIGHT = 36;
const MetricEmbeddableComponent = ({
  fields,
  id,
  inspectTitle,
  timerange
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    className: "metricEmbeddable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, fields.map(field => /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    key: `stat-items-field-${field.key}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }, field.icon && /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: field.icon,
    color: field.color,
    size: "l",
    "data-test-subj": "stat-icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, field.lensAttributes && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "stat-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-metric",
    height: CHART_HEIGHT,
    id: `${id}-${field.key}-metric-embeddable`,
    lensAttributes: field.lensAttributes,
    timerange: timerange,
    inspectTitle: inspectTitle,
    scopeId: newDataViewPickerEnabled ? _constants.DataViewManagerScopeName.explore : _constants.DataViewManagerScopeName.default,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 19
    }
  }))), field.description != null && /*#__PURE__*/_react.default.createElement(_utils.FlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_utils.StatValue, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "stat-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 19
    }
  }, field.description)))))));
};
const MetricEmbeddable = exports.MetricEmbeddable = /*#__PURE__*/_react.default.memo(MetricEmbeddableComponent);