"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScorePreviewTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../severity/common");
var _links = require("../../../common/components/links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_score_management/risk_score_preview_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RiskScorePreviewTable = ({
  items,
  type
}) => {
  const columns = [{
    field: 'id_value',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.previewTable.nameColumnTitle",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }),
    render: entityName => /*#__PURE__*/_react.default.createElement(_links.EntityDetailsLink, {
      entityName: entityName,
      entityType: type,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    })
  }, {
    field: 'calculated_level',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.previewTable.levelColumnTitle",
      defaultMessage: "Level",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 9
      }
    }),
    render: risk => {
      if (risk != null) {
        return /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
          severity: risk,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 18
          }
        });
      }
      return '';
    }
  }, {
    field: 'calculated_score_norm',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.riskScore.previewTable.scoreNormColumnTitle",
      defaultMessage: "Score norm",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }),
    render: scoreNorm => {
      if (scoreNorm != null) {
        return Math.round(scoreNorm * 100) / 100;
      }
      return '';
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": `${type}-risk-preview-table`,
    responsiveBreakpoint: false,
    items: items,
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  });
};
exports.RiskScorePreviewTable = RiskScorePreviewTable;