"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefetchQueryById = void 0;
var _react = require("react");
var _use_selector = require("../../../common/hooks/use_selector");
var _store = require("../../../common/store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRefetchQueryById = QueryId => {
  const getGlobalQuery = (0, _react.useMemo)(() => _store.inputsSelectors.globalQueryByIdSelector(), []);
  const {
    refetch
  } = (0, _use_selector.useDeepEqualSelector)(state => getGlobalQuery(state, QueryId));
  return refetch;
};
exports.useRefetchQueryById = useRefetchQueryById;