"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldEditFormContextProvider = FieldEditFormContextProvider;
exports.useFieldEditFormContext = useFieldEditFormContext;
var _react = _interopRequireWildcard(require("react"));
var _invariant = require("../../../../../../../../common/utils/invariant");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/field_final_side/context/field_edit_form_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldEditFormContext = /*#__PURE__*/(0, _react.createContext)(null);

/**
 * FieldEditFormContext helps to encapsulate form related logic in `field_final_side` folder.
 *
 * The only purpose is to obtain the recent form handler and provide it for consumers in
 * in the `field_final_side` folder.
 */
function FieldEditFormContextProvider({
  children
}) {
  // Using reference reduces unnecessary re-renders though we need to re-render children
  // whenever something in the form changes like validity state to be able to reflect that changes.
  const formRef = (0, _react.useRef)();
  // Setting the state re-renders the component and its children. The state value is ignored since
  // we use a ref here. In that case it doesn't re-render components upon form cleanup. In that case
  // the edit component disappears and we aren't interested in the form's state anymore.
  const [, setForm] = (0, _react.useState)();
  const registerForm = (0, _react.useCallback)(formToRegister => {
    // Guard against subtle bugs. In attempt of using two forms throw an exception.
    if (formRef.current) {
      throw new Error('Unexpected new form registration while the old one was not cleaned. Do you properly cleanup form by returning registerForm result from useEffect.');
    }
    formRef.current = formToRegister;
    setForm(formToRegister);
    return () => formRef.current = undefined;
  }, [formRef, setForm]);
  return /*#__PURE__*/_react.default.createElement(FieldEditFormContext.Provider, {
    value: {
      form: formRef.current,
      registerForm
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, children);
}
function useFieldEditFormContext() {
  const context = (0, _react.useContext)(FieldEditFormContext);
  (0, _invariant.invariant)(context !== null, 'useFieldEditFormContext must be used inside a FieldEditFormProvider');
  return context;
}