"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentTypeVendorLogo = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _translations = require("../../../../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/endpoint/agents/agent_type_vendor_logo/agent_type_vendor_logo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchSentinelOneLogoSvg = () => Promise.resolve().then(() => _interopRequireWildcard(require('./images/sentinelone_logo.svg'))).then(response => response.default);
const fetchCrowdstrikeLogoSvg = () => Promise.resolve().then(() => _interopRequireWildcard(require('./images/crowdstrike_logo.svg'))).then(response => response.default);
const fetchMicrosoftDefenderEndpointLogoSvg = () => Promise.resolve().then(() => _interopRequireWildcard(require('./images/microsoft_defender_endpoint.svg'))).then(response => response.default);
const AgentTypeVendorLogo = exports.AgentTypeVendorLogo = /*#__PURE__*/(0, _react.memo)(({
  agentType,
  ...otherIconProps
}) => {
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  const [iconType, setIconType] = (0, _react.useState)('empty');
  (0, _react.useEffect)(() => {
    if (isMounted()) {
      const setSvgToState = svgContent => {
        if (isMounted()) {
          setIconType(svgContent);
        }
      };
      switch (agentType) {
        case 'endpoint':
          setIconType('logoSecurity');
          break;
        case 'sentinel_one':
          fetchSentinelOneLogoSvg().then(setSvgToState);
          break;
        case 'crowdstrike':
          fetchCrowdstrikeLogoSvg().then(setSvgToState);
          break;
        case 'microsoft_defender_endpoint':
          fetchMicrosoftDefenderEndpointLogoSvg().then(setSvgToState);
          break;
      }
    }
  }, [agentType, isMounted]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
    type: iconType,
    title: iconType === 'empty' ? '' : (0, _translations.getAgentTypeName)(agentType),
    size: "m"
  }, otherIconProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
});
AgentTypeVendorLogo.displayName = 'AgentTypeVendorLogo';