"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _execution_status = require("../../utils/execution_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/common/status_badge/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const statusTextWrapperClassName = (0, _css.css)`
  width: 100%;
  display: inline-grid;
`;
const StatusBadge = exports.StatusBadge = /*#__PURE__*/_react.default.memo(({
  schedule
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!schedule.lastExecution) {
    return null;
  }
  const executionStatus = schedule.lastExecution.status;
  const executionMessage = schedule.lastExecution.message;
  const label = (0, _execution_status.getExecutionStatusLabel)(executionStatus);
  const color = (0, _execution_status.getExecutionStatusHealthColor)(executionStatus, euiTheme);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: executionMessage !== null && executionMessage !== void 0 ? executionMessage : label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    "data-test-subj": 'scheduleExecutionStatus',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: statusTextWrapperClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, label))));
});
StatusBadge.displayName = 'StatusBadge';