"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TechnicalPreviewBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/technical_preview_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TechnicalPreviewBadge = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    css: (0, _react2.css)`
        margin-left: ${euiTheme.size.s};
      `,
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.technicalPreviewLabel', {
      defaultMessage: 'Technical Preview'
    }),
    size: "s",
    color: "subdued",
    tooltipContent: _i18n.i18n.translate('xpack.securitySolution.assetInventory.technicalPreviewTooltip', {
      defaultMessage: 'This functionality is experimental and not supported. It may change or be removed at any time.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 16,
      columnNumber: 5
    }
  });
};
exports.TechnicalPreviewBadge = TechnicalPreviewBadge;