"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LIST_ENTITIES_URL = exports.ENTITY_STORE_URL = exports.ENTITY_STORE_UPDATES_INDEX_PATTERN = exports.ENTITY_STORE_SOURCE_REQUIRED_ES_INDEX_PRIVILEGES = exports.ENTITY_STORE_REQUIRED_ES_CLUSTER_PRIVILEGES = exports.ENTITY_STORE_INTERNAL_PRIVILEGES_URL = exports.ENTITY_STORE_INDEX_PATTERN = exports.ENTITY_STORE_HISTORY_INDEX_PATTERN = exports.ENTITIES_URL = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Entity Store routes
 */

const ENTITY_STORE_URL = exports.ENTITY_STORE_URL = '/api/entity_store';
const ENTITY_STORE_INTERNAL_PRIVILEGES_URL = exports.ENTITY_STORE_INTERNAL_PRIVILEGES_URL = `${ENTITY_STORE_URL}/privileges`;
const ENTITIES_URL = exports.ENTITIES_URL = `${ENTITY_STORE_URL}/entities`;
const LIST_ENTITIES_URL = exports.LIST_ENTITIES_URL = `${ENTITIES_URL}/list`;
const ENTITY_STORE_REQUIRED_ES_CLUSTER_PRIVILEGES = exports.ENTITY_STORE_REQUIRED_ES_CLUSTER_PRIVILEGES = ['manage_index_templates', 'manage_transform', 'manage_ingest_pipelines', 'manage_enrich'];

// Privileges required for the transform to run
const ENTITY_STORE_SOURCE_REQUIRED_ES_INDEX_PRIVILEGES = exports.ENTITY_STORE_SOURCE_REQUIRED_ES_INDEX_PRIVILEGES = ['read', 'view_index_metadata'];

// The index pattern for the entity store has to support '.entities.v1.latest.noop' index
const ENTITY_STORE_INDEX_PATTERN = exports.ENTITY_STORE_INDEX_PATTERN = '.entities.*';
const ENTITY_STORE_HISTORY_INDEX_PATTERN = exports.ENTITY_STORE_HISTORY_INDEX_PATTERN = '.entities.*history*';
const ENTITY_STORE_UPDATES_INDEX_PATTERN = exports.ENTITY_STORE_UPDATES_INDEX_PATTERN = '.entities.v1.updates.*';