"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleExecutionMetrics = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Execution Metrics Schema
 *   version: not applicable
 */

const RuleExecutionMetrics = exports.RuleExecutionMetrics = _zod.z.object({
  /**
   * Total time spent performing ES searches as measured by Kibana; includes network latency and time spent serializing/deserializing request/response
   */
  total_search_duration_ms: _zod.z.number().int().min(0).optional(),
  /**
   * Total time spent indexing documents during current rule execution cycle
   */
  total_indexing_duration_ms: _zod.z.number().int().min(0).optional(),
  /**
   * Total time spent enriching documents during current rule execution cycle
   */
  total_enrichment_duration_ms: _zod.z.number().int().min(0).optional(),
  /**
   * Duration in seconds of execution gap
   */
  execution_gap_duration_s: _zod.z.number().int().min(0).optional(),
  /**
   * Count of frozen indices queried during the rule execution. These indices could not be entirely excluded after applying the time range filter.
   */
  frozen_indices_queried_count: _zod.z.number().int().min(0).optional(),
  /**
   * Range of the execution gap
   */
  gap_range: _zod.z.object({
    /**
     * Start date of the execution gap
     */
    gte: _zod.z.string(),
    /**
     * End date of the execution gap
     */
    lte: _zod.z.string()
  }).optional()
});