"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksImageCards = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _landing_links_image_card = _interopRequireDefault(require("./landing_links_image_card"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/packages/navigation/src/landing_links/landing_links_images_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  return {
    accordion: (0, _react2.css)`
      .euiAccordion__childWrapper {
        overflow: visible;
      }
    `
  };
};
const LandingLinksImageCards = exports.LandingLinksImageCards = /*#__PURE__*/_react.default.memo(function LandingLinksImageCards({
  items,
  urlState,
  onLinkClick
}) {
  const landingLinksAccordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'landingLinksAccordion'
  });
  const styles = useStyles();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    borderRadius: "m",
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: landingLinksAccordionId,
    initialIsOpen: true,
    css: styles.accordion,
    "data-test-subj": "LandingImageCards-accordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "row",
      justifyContent: "flexStart",
      alignItems: "center",
      "data-test-subj": "LandingImageCards-accordionButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoSecurity",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 19
      }
    }, i18n.LANDING_LINKS_ACCORDION_HEADER)))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, items.map(item => {
    const {
      id
    } = item;
    return /*#__PURE__*/_react.default.createElement(_landing_links_image_card.default, {
      item: item,
      urlState: urlState,
      onLinkClick: onLinkClick,
      key: id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 17
      }
    });
  }))));
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LandingLinksImageCards;