"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleTutorialsGroup = void 0;
var _searchCodeExamples = require("@kbn/search-code-examples");
var _tryInConsole = require("@kbn/try-in-console");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/console_tutorials_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConsoleTutorialsGroup = () => {
  const {
    application,
    share,
    console: consolePlugin
  } = (0, _use_kibana.useKibana)().services;
  const [hoveredTutorial, setHoveredTutorial] = _react.default.useState(null);
  const tutorials = [{
    title: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.basicsTitle', {
      defaultMessage: 'Search basics'
    }),
    dataTestSubj: 'console_tutorials_search_basics',
    description: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.basicsDescription', {
      defaultMessage: 'Learn how to create an index, add documents, and basic search techniques.'
    }),
    request: _searchCodeExamples.consoleTutorials.basics,
    duration: 3
  }, {
    title: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.semanticTitle', {
      defaultMessage: 'Semantic search'
    }),
    dataTestSubj: 'console_tutorials_semantic_search',
    description: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.semanticDescription', {
      defaultMessage: 'Learn semantic search techniques to understand intent and deliver more accurate, relevant results.'
    }),
    request: _searchCodeExamples.consoleTutorials.semanticSearch,
    duration: 3
  }, {
    title: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.esqlTitle', {
      defaultMessage: 'ES|QL'
    }),
    dataTestSubj: 'console_tutorials_esql',
    description: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.esqlDescription', {
      defaultMessage: "Learn how to use Elastic's piped query language to simplify data investigations."
    }),
    request: _searchCodeExamples.consoleTutorials.esql,
    duration: 4
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: 'column',
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.label', {
    defaultMessage: 'Get started with the API'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, tutorials.map((tutorial, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: hoveredTutorial === tutorial.dataTestSubj,
    display: hoveredTutorial === tutorial.dataTestSubj ? 'plain' : 'subdued',
    onMouseEnter: () => setHoveredTutorial(tutorial.dataTestSubj),
    onMouseLeave: () => setHoveredTutorial(null),
    paddingSize: "s",
    title: tutorial.title,
    titleSize: "xs",
    textAlign: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    justifyContent: "center",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 23
    }
  }, "~", tutorial.duration, " min"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 21
    }
  }, tutorial.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
    request: tutorial.request,
    application: application,
    consolePlugin: consolePlugin,
    sharePlugin: share,
    telemetryId: tutorial.dataTestSubj,
    "data-test-subj": tutorial.dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 21
    }
  })))))))));
};
exports.ConsoleTutorialsGroup = ConsoleTutorialsGroup;