"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGettingStartedBreadcrumbs = void 0;
var _react = require("react");
var _common = require("../../common");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGettingStartedBreadcrumbs = () => {
  var _cloud$isServerlessEn;
  const {
    cloud,
    http,
    searchNavigation,
    chrome
  } = (0, _use_kibana.useKibana)().services;
  const isServerless = (_cloud$isServerlessEn = cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled) !== null && _cloud$isServerlessEn !== void 0 ? _cloud$isServerlessEn : false;
  (0, _react.useEffect)(() => {
    chrome.docTitle.change(_common.PLUGIN_NAME);
    searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.setSearchBreadCrumbs(isServerless ? [] : [{
      text: _common.PLUGIN_NAME
    }]);
    return () => {
      // Clear breadcrumbs on unmount;
      searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.breadcrumbs.clearBreadcrumbs();
    };
  }, [http, searchNavigation, isServerless, chrome]);
};
exports.useGettingStartedBreadcrumbs = useGettingStartedBreadcrumbs;