"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorCronEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cron_editor = require("../cron_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/scheduling/connector_cron_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorCronEditor = ({
  dataTelemetryIdPrefix,
  disabled = false,
  frequencyBlockList = [],
  hasSyncTypeChanges,
  onReset,
  onSave,
  scheduling,
  setHasSyncTypeChanges,
  status
}) => {
  var _scheduling$interval;
  const [newInterval, setNewInterval] = (0, _react.useState)(scheduling.interval);
  const [fieldToPreferredValueMap, setFieldToPreferredValueMap] = (0, _react.useState)({});
  const [simpleCron, setSimpleCron] = (0, _react.useState)({
    expression: (_scheduling$interval = scheduling.interval) !== null && _scheduling$interval !== void 0 ? _scheduling$interval : '',
    frequency: scheduling.interval ? cronToFrequency(scheduling.interval) : 'HOUR'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_cron_editor.CronEditor, {
    "data-telemetry-id": `${dataTelemetryIdPrefix}-connector-scheduling-editSchedule`,
    disabled: !scheduling.enabled || disabled,
    fieldToPreferredValueMap: fieldToPreferredValueMap,
    cronExpression: simpleCron.expression,
    frequency: simpleCron.frequency,
    onChange: ({
      cronExpression: expression,
      frequency,
      fieldToPreferredValueMap: newFieldToPreferredValueMap
    }) => {
      setSimpleCron({
        expression,
        frequency
      });
      setFieldToPreferredValueMap(newFieldToPreferredValueMap);
      setNewInterval(expression);
      setHasSyncTypeChanges(true);
    },
    frequencyBlockList: frequencyBlockList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `${dataTelemetryIdPrefix}-connector-scheduling-resetSchedule`,
    disabled: !hasSyncTypeChanges || status || disabled,
    onClick: () => {
      var _scheduling$interval2;
      setNewInterval(scheduling.interval);
      setSimpleCron({
        expression: (_scheduling$interval2 = scheduling.interval) !== null && _scheduling$interval2 !== void 0 ? _scheduling$interval2 : '',
        frequency: scheduling.interval ? cronToFrequency(scheduling.interval) : 'HOUR'
      });
      setHasSyncTypeChanges(false);
      if (onReset) {
        onReset();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('searchConnectors.connectorScheduling.resetButton.label', {
    defaultMessage: 'Reset'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": `${dataTelemetryIdPrefix}-connector-scheduling-saveSchedule`,
    disabled: !hasSyncTypeChanges || status || disabled,
    onClick: () => onSave && onSave(newInterval),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('searchConnectors.connectorScheduling.saveButton.label', {
    defaultMessage: 'Save'
  }))))));
};
exports.ConnectorCronEditor = ConnectorCronEditor;
function cronToFrequency(cron) {
  const fields = cron.split(' ');
  if (fields.length < 4) {
    return 'YEAR';
  }
  if (fields[1] === '*' || fields[1].includes(',')) {
    return 'MINUTE';
  }
  if (fields[2] === '*') {
    return 'HOUR';
  }
  if (fields[3] === '*') {
    return 'DAY';
  }
  if (fields[3] === '?') {
    return 'WEEK';
  }
  if (fields[4] === '*') {
    return 'MONTH';
  }
  return 'YEAR';
}