"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobCreate = void 0;
var _reactRedux = require("react-redux");
var _job_create = require("./job_create");
var _selectors = require("../../store/selectors");
var _actions = require("../../store/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    isSaving: (0, _selectors.isSaving)(state),
    saveError: (0, _selectors.getCreateJobError)(state),
    jobToClone: (0, _selectors.getCloneJobConfig)(state)
  };
};
const mapDispatchToProps = dispatch => {
  return {
    createJob: jobConfig => {
      dispatch((0, _actions.createJob)(jobConfig));
    },
    clearCreateJobErrors: () => {
      dispatch((0, _actions.clearCreateJobErrors)());
    },
    clearCloneJob: () => {
      dispatch((0, _actions.clearCloneJob)());
    }
  };
};
const JobCreate = exports.JobCreate = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_job_create.JobCreate);