"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNFunctionSortField = exports.TopNComparisonFunctionSortField = void 0;
exports.createTopNFunctions = createTopNFunctions;
exports.topNFunctionSortFieldRt = exports.topNComparisonFunctionSortFieldRt = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _ = require("..");
var _profiling = require("./profiling");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createTopNFunctions({
  endIndex,
  events,
  executables,
  samplingRate,
  stackFrames,
  stackTraces,
  startIndex,
  showErrorFrames
}) {
  // The `count` associated with a frame provides the total number of
  // traces in which that node has appeared at least once. However, a
  // frame may appear multiple times in a trace, and thus to avoid
  // counting it multiple times we need to record the frames seen so
  // far in each trace.
  let totalCount = 0;
  const topNFunctions = new Map();
  // The factor to apply to sampled events to scale the estimated result correctly.
  const scalingFactor = 1.0 / samplingRate;

  // Collect metadata and inclusive + exclusive counts for each distinct frame.
  for (const [stackTraceID, count] of events) {
    var _stackTraces$get;
    const uniqueFrameGroupsPerEvent = new Set();
    const scaledCount = count * scalingFactor;
    totalCount += scaledCount;

    // It is possible that we do not have a stacktrace for an event,
    // e.g. when stopping the host agent or on network errors.
    const stackTrace = (_stackTraces$get = stackTraces.get(stackTraceID)) !== null && _stackTraces$get !== void 0 ? _stackTraces$get : _.emptyStackTrace;
    const selfAnnualCO2kgs = stackTrace.selfAnnualCO2Kgs;
    const selfAnnualCostUSD = stackTrace.selfAnnualCostUSD;
    const lenStackTrace = stackTrace.FrameIDs.length;

    // Error frames only appear as first frame in a stacktrace.
    const start = !showErrorFrames && lenStackTrace > 0 && (0, _profiling.isErrorFrame)(stackTrace.Types[0]) ? 1 : 0;
    for (let i = start; i < lenStackTrace; i++) {
      var _stackFrames$get, _executables$get;
      const frameID = stackTrace.FrameIDs[i];
      const fileID = stackTrace.FileIDs[i];
      const addressOrLine = stackTrace.AddressOrLines[i];
      const frame = (_stackFrames$get = stackFrames.get(frameID)) !== null && _stackFrames$get !== void 0 ? _stackFrames$get : _.emptyStackFrame;
      const executable = (_executables$get = executables.get(fileID)) !== null && _executables$get !== void 0 ? _executables$get : _.emptyExecutable;
      const frameGroupID = (0, _.createFrameGroupID)(fileID, addressOrLine, executable.FileName, frame.FileName, frame.FunctionName);
      let topNFunction = topNFunctions.get(frameGroupID);
      if (topNFunction === undefined) {
        const metadata = (0, _.createStackFrameMetadata)({
          FrameID: frameID,
          FileID: fileID,
          AddressOrLine: addressOrLine,
          FrameType: stackTrace.Types[i],
          Inline: frame.Inline,
          FunctionName: frame.FunctionName,
          FunctionOffset: frame.FunctionOffset,
          SourceLine: frame.LineNumber,
          SourceFilename: frame.FileName,
          ExeFileName: executable.FileName
        });
        topNFunction = {
          Frame: metadata,
          FrameGroupID: frameGroupID,
          CountExclusive: 0,
          CountInclusive: 0,
          selfAnnualCO2kgs: 0,
          totalAnnualCO2kgs: 0,
          selfAnnualCostUSD: 0,
          totalAnnualCostUSD: 0
        };
        topNFunctions.set(frameGroupID, topNFunction);
      }
      if (!uniqueFrameGroupsPerEvent.has(frameGroupID)) {
        uniqueFrameGroupsPerEvent.add(frameGroupID);
        topNFunction.CountInclusive += scaledCount;
        topNFunction.totalAnnualCO2kgs += selfAnnualCO2kgs;
        topNFunction.totalAnnualCostUSD += selfAnnualCostUSD;
      }
      if (i === lenStackTrace - 1) {
        // Leaf frame: sum up counts for exclusive CPU.
        topNFunction.CountExclusive += scaledCount;
        topNFunction.selfAnnualCO2kgs += selfAnnualCO2kgs;
        topNFunction.selfAnnualCostUSD += selfAnnualCostUSD;
      }
    }
  }

  // Sort in descending order by exclusive CPU. Same values should appear in a
  // stable order, so compare the FrameGroup in this case.
  const topN = [...topNFunctions.values()];
  topN.sort((a, b) => {
    if (a.CountExclusive > b.CountExclusive) {
      return 1;
    }
    if (a.CountExclusive < b.CountExclusive) {
      return -1;
    }
    return a.FrameGroupID.localeCompare(b.FrameGroupID);
  }).reverse();
  if (startIndex > topN.length) {
    startIndex = topN.length;
  }
  if (endIndex > topN.length) {
    endIndex = topN.length;
  }
  const framesAndCountsAndIds = topN.slice(startIndex, endIndex).map((frameAndCount, i) => {
    const countExclusive = frameAndCount.CountExclusive;
    const countInclusive = frameAndCount.CountInclusive;
    return {
      Rank: i + 1,
      Frame: frameAndCount.Frame,
      CountExclusive: countExclusive,
      CountInclusive: countInclusive,
      Id: frameAndCount.FrameGroupID,
      selfAnnualCO2kgs: frameAndCount.selfAnnualCO2kgs,
      selfAnnualCostUSD: frameAndCount.selfAnnualCostUSD,
      totalAnnualCO2kgs: frameAndCount.totalAnnualCO2kgs,
      totalAnnualCostUSD: frameAndCount.totalAnnualCostUSD,
      subGroups: {}
    };
  });
  const sumSelfCPU = (0, _lodash.sumBy)(framesAndCountsAndIds, 'CountExclusive');
  const sumTotalCPU = (0, _lodash.sumBy)(framesAndCountsAndIds, 'CountInclusive');
  const totalAnnualCO2Kgs = (0, _lodash.sumBy)(framesAndCountsAndIds, 'selfAnnualCO2kgs');
  const totalAnnualCostUSD = (0, _lodash.sumBy)(framesAndCountsAndIds, 'selfAnnualCostUSD');
  return {
    TotalCount: totalCount,
    TopN: framesAndCountsAndIds,
    SamplingRate: samplingRate,
    selfCPU: sumSelfCPU,
    totalCPU: sumTotalCPU,
    totalAnnualCO2Kgs,
    totalAnnualCostUSD
  };
}
let TopNFunctionSortField = exports.TopNFunctionSortField = /*#__PURE__*/function (TopNFunctionSortField) {
  TopNFunctionSortField["Rank"] = "rank";
  TopNFunctionSortField["Frame"] = "frame";
  TopNFunctionSortField["Samples"] = "samples";
  TopNFunctionSortField["SelfCPU"] = "selfCPU";
  TopNFunctionSortField["TotalCPU"] = "totalCPU";
  TopNFunctionSortField["Diff"] = "diff";
  TopNFunctionSortField["AnnualizedCo2"] = "annualizedCo2";
  TopNFunctionSortField["AnnualizedDollarCost"] = "annualizedDollarCost";
  return TopNFunctionSortField;
}({});
const topNFunctionSortFieldRt = exports.topNFunctionSortFieldRt = t.union([t.literal(TopNFunctionSortField.Rank), t.literal(TopNFunctionSortField.Frame), t.literal(TopNFunctionSortField.Samples), t.literal(TopNFunctionSortField.SelfCPU), t.literal(TopNFunctionSortField.TotalCPU), t.literal(TopNFunctionSortField.Diff), t.literal(TopNFunctionSortField.AnnualizedCo2), t.literal(TopNFunctionSortField.AnnualizedDollarCost)]);
let TopNComparisonFunctionSortField = exports.TopNComparisonFunctionSortField = /*#__PURE__*/function (TopNComparisonFunctionSortField) {
  TopNComparisonFunctionSortField["ComparisonRank"] = "comparison_rank";
  TopNComparisonFunctionSortField["ComparisonFrame"] = "comparison_frame";
  TopNComparisonFunctionSortField["ComparisonSamples"] = "comparison_samples";
  TopNComparisonFunctionSortField["ComparisonSelfCPU"] = "comparison_selfCPU";
  TopNComparisonFunctionSortField["ComparisonTotalCPU"] = "comparison_totalCPU";
  TopNComparisonFunctionSortField["ComparisonDiff"] = "comparison_diff";
  return TopNComparisonFunctionSortField;
}({});
const topNComparisonFunctionSortFieldRt = exports.topNComparisonFunctionSortFieldRt = t.union([t.literal(TopNComparisonFunctionSortField.ComparisonRank), t.literal(TopNComparisonFunctionSortField.ComparisonFrame), t.literal(TopNComparisonFunctionSortField.ComparisonSamples), t.literal(TopNComparisonFunctionSortField.ComparisonSelfCPU), t.literal(TopNComparisonFunctionSortField.ComparisonTotalCPU), t.literal(TopNComparisonFunctionSortField.ComparisonDiff)]);