"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingRouter = useProfilingRouter;
var _reactRouterDom = require("react-router-dom");
var _use_profiling_dependencies = require("../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _routing = require("../routing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProfilingRouter() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const link = (...args) => {
    // @ts-expect-error
    return _routing.profilingRouter.link(...args);
  };
  return {
    ..._routing.profilingRouter,
    push: (...args) => {
      const next = link(...args);
      history.push(next);
    },
    replace: (path, ...args) => {
      const next = link(path, ...args);
      history.replace(next);
    },
    link: (path, ...args) => {
      return core.http.basePath.prepend('/app/profiling' + link(path, ...args));
    }
  };
}