"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryResult = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_live_query_details = require("../../actions/use_live_query_details");
var _translations = require("../../agents/translations");
var _pack_queries_status_table = require("../../live_queries/form/pack_queries_status_table");
var _contexts = require("../../common/contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/shared_components/osquery_results/osquery_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line react/display-name
const OsqueryResult = exports.OsqueryResult = /*#__PURE__*/_react.default.memo(({
  actionId,
  ruleName,
  startDate,
  ecsData
}) => {
  const [isLive, setIsLive] = (0, _react.useState)(false);
  const {
    data
  } = (0, _use_live_query_details.useLiveQueryDetails)({
    actionId,
    isLive
  });
  (0, _react.useLayoutEffect)(() => {
    setIsLive(() => !((data === null || data === void 0 ? void 0 : data.status) === 'completed'));
  }, [data === null || data === void 0 ? void 0 : data.status]);
  return /*#__PURE__*/_react.default.createElement(_contexts.AlertAttachmentContext.Provider, {
    value: ecsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: ruleName,
    timestamp: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: startDate,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 22
      }
    }),
    event: _translations.ATTACHED_QUERY,
    "data-test-subj": 'osquery-results-comment',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_pack_queries_status_table.PackQueriesStatusTable, {
    actionId: actionId,
    data: data === null || data === void 0 ? void 0 : data.queries,
    startDate: data === null || data === void 0 ? void 0 : data['@timestamp'],
    expirationDate: data === null || data === void 0 ? void 0 : data.expiration,
    agentIds: data === null || data === void 0 ? void 0 : data.agents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }));
});