"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditToolService = exports.useEditTool = void 0;
var _onechatBrowser = require("@kbn/onechat-browser");
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _query_keys = require("../../query_keys");
var _i18n = require("../../utils/i18n");
var _use_onechat_service = require("../use_onechat_service");
var _use_toasts = require("../use_toasts");
var _use_tools = require("./use_tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEditToolService = ({
  onSuccess,
  onError
} = {}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    toolsService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    mutate,
    mutateAsync,
    isLoading
  } = (0, _reactQuery.useMutation)({
    mutationFn: ({
      toolId,
      tool
    }) => toolsService.update(toolId, tool),
    onSuccess,
    onError,
    onSettled: () => queryClient.invalidateQueries({
      queryKey: _query_keys.queryKeys.tools.all
    })
  });
  return {
    updateToolSync: mutate,
    updateTool: mutateAsync,
    isLoading
  };
};
exports.useEditToolService = useEditToolService;
const useEditTool = ({
  toolId,
  onSuccess,
  onError,
  onLoadingError
}) => {
  const {
    addSuccessToast,
    addErrorToast
  } = (0, _use_toasts.useToasts)();
  const {
    tool: editingTool,
    isLoading
  } = (0, _use_tools.useTool)({
    toolId,
    onLoadingError
  });
  const handleSuccess = (0, _react.useCallback)((response, variables, context) => {
    addSuccessToast({
      title: _i18n.labels.tools.editEsqlToolSuccessToast(response.id)
    });
    onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess(response, variables, context);
  }, [addSuccessToast, onSuccess]);
  const handleError = (0, _react.useCallback)((error, variables, context) => {
    addErrorToast({
      title: _i18n.labels.tools.editEsqlToolErrorToast(variables.toolId),
      text: (0, _onechatBrowser.formatOnechatErrorMessage)(error)
    });
    onError === null || onError === void 0 ? void 0 : onError(error, variables, context);
  }, [addErrorToast, onError]);
  const {
    updateTool,
    isLoading: isSubmitting
  } = useEditToolService({
    onSuccess: handleSuccess,
    onError: handleError
  });
  const handleEditTool = (0, _react.useCallback)(async toolData => {
    return updateTool({
      toolId,
      tool: toolData
    });
  }, [updateTool, toolId]);
  return {
    tool: editingTool,
    isLoading,
    isSubmitting,
    editTool: handleEditTool
  };
};
exports.useEditTool = useEditTool;