"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationActions = VisualizationActions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _edit_visualization_button = require("./edit_visualization_button");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/esql/visualize_esql/visualization_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function VisualizationActions({
  onSave,
  uiActions,
  lensInput,
  lensLoadEvent,
  setLensInput
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!lensInput) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "visualization-button-actions",
    css: (0, _styles.actionsContainer)(euiTheme),
    "data-test-subj": "visualizationButtonActions",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_visualization_button.EditVisualizationButton, {
    uiActions: uiActions,
    lensInput: lensInput,
    lensLoadEvent: lensLoadEvent,
    onAttributesChange: attrs => setLensInput({
      ...lensInput,
      attributes: attrs
    }),
    onApply: onSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    color: "text",
    size: "s",
    iconType: "save",
    "aria-label": _edit_visualization_button.saveButtonLabel,
    css: (0, _react2.css)({
      marginLeft: '-1px'
    }) // avoid double border
    ,
    onClick: onSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }));
}