"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomHeader = CustomHeader;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _back_button = require("../shared/back_button");
var _logo_icon = require("../shared/logo_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/header/custom_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CustomHeader({
  euiIconType,
  logo,
  headlineCopy,
  captionCopy,
  isTechnicalPreview = false
}) {
  const theme = (0, _eui.useEuiTheme)();
  const shadow = (0, _eui.useEuiShadow)('s');
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Section, {
    css: (0, _react.css)`
        border-bottom: ${theme.euiTheme.border.thin};
      `,
    grow: false,
    paddingSize: "l",
    restrictWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_back_button.BackButton, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.button.returnButtonLabel', {
    defaultMessage: 'Return'
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
              border-radius: ${theme.euiTheme.border.radius.medium};
              ${shadow}
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_logo_icon.LogoIcon, {
    euiIconType: euiIconType,
    isAvatar: !!euiIconType,
    logo: logo,
    size: "xxl",
    css: (0, _react.css)`
                margin: 12px;
                width: 56px;
                height: 56px;
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement("h1", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }, headlineCopy)), isTechnicalPreview && /*#__PURE__*/_react2.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.techPreviewBadge.label', {
      defaultMessage: 'Technical preview'
    }),
    size: "m",
    color: "hollow",
    tooltipContent: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.techPreviewBadge.tooltip', {
      defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
    }),
    tooltipPosition: 'right',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, captionCopy)))));
}