"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultDFAListState = exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _analytics_list = require("./components/analytics_list");
var _use_refresh_interval = require("./components/analytics_list/use_refresh_interval");
var _node_available_warning = require("../../../components/node_available_warning");
var _saved_objects_warning = require("../../../components/saved_objects_warning");
var _upgrade = require("../../../components/upgrade");
var _common = require("./components/analytics_list/common");
var _locator = require("../../../../../common/constants/locator");
var _help_menu = require("../../../components/help_menu");
var _kibana = require("../../../contexts/kibana");
var _common2 = require("../../common");
var _page_header = require("../../../components/page_header");
var _create_analytics_button = require("./components/create_analytics_button/create_analytics_button");
var _check_capabilities = require("../../../capabilities/check_capabilities");
var _import_export_jobs = require("../../../components/import_export_jobs");
var _synchronize_saved_objects_button = require("../../../jobs/jobs_list/components/top_level_actions/synchronize_saved_objects_button");
var _page_title = require("../../../components/page_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDefaultDFAListState = () => ({
  pageIndex: 0,
  pageSize: 10,
  sortField: _common.DataFrameAnalyticsListColumn.id,
  sortDirection: 'asc'
});
exports.getDefaultDFAListState = getDefaultDFAListState;
const Page = () => {
  const [blockRefresh, setBlockRefresh] = (0, _react.useState)(false);
  const [dfaPageState, setDfaPageState] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE_FOR_URL, getDefaultDFAListState());
  (0, _use_refresh_interval.useRefreshInterval)(setBlockRefresh);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    refresh
  } = (0, _common2.useRefreshAnalyticsList)({
    isLoading: setIsLoading
  });
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const helpLink = docLinks.links.ml.dataFrameAnalytics;
  const mlManagementLocator = (0, _kibana.useMlManagementLocator)();
  const navigateToSourceSelection = (0, _react.useCallback)(async () => {
    await (mlManagementLocator === null || mlManagementLocator === void 0 ? void 0 : mlManagementLocator.navigate({
      sectionId: 'ml',
      appId: `analytics/${_locator.ML_PAGES.DATA_FRAME_ANALYTICS_SOURCE_SELECTION}`
    }));
  }, [mlManagementLocator]);
  const canCreateAnalytics = (0, _check_capabilities.usePermissionCheck)('canCreateDataFrameAnalytics');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    wrapHeader: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_synchronize_saved_objects_button.SynchronizeSavedObjectsButton, {
      refreshJobs: refresh,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_import_export_jobs.ExportJobsFlyout, {
      isDisabled: !canCreateAnalytics,
      currentTab: 'data-frame-analytics',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_import_export_jobs.ImportJobsFlyout, {
      isDisabled: !canCreateAnalytics,
      onImportComplete: refresh,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_create_analytics_button.CreateAnalyticsButton, {
      size: "m",
      navigateToSourceSelection: navigateToSourceSelection,
      isDisabled: !canCreateAnalytics,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataframe.analyticsList.title",
      defaultMessage: "Data Frame Analytics Jobs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_node_available_warning.NodeAvailableWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: refresh,
    forceRefresh: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_analytics_list.DataFrameAnalyticsList, {
    blockRefresh: blockRefresh,
    pageState: dfaPageState,
    updatePageState: setDfaPageState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }));
};
exports.Page = Page;