"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNumTopClasses = void 0;
var _analytics_utils = require("./analytics_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get the `num_top_classes` attribute of a DFA classification configuration
 *
 * @param {AnalysisConfig} analysis The analysis configuration
 * @returns {ClassificationAnalysis['classification']['num_top_classes']}
 */
const getNumTopClasses = analysis => {
  let numTopClasses;
  if ((0, _analytics_utils.isClassificationAnalysis)(analysis) && analysis.classification.num_top_classes !== undefined) {
    numTopClasses = analysis.classification.num_top_classes;
  }
  return numTopClasses;
};
exports.getNumTopClasses = getNumTopClasses;