"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTileRequest = getTileRequest;
var _constants = require("../../../../common/constants");
var _mvt_request_body = require("../../../../common/mvt_request_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSearchParams(url) {
  const split = url.split('?');
  const queryString = split.length <= 1 ? '' : split[1];
  return new URLSearchParams(queryString);
}
function getTileRequest(tileRequest) {
  const searchParams = getSearchParams(tileRequest.tileUrl);
  const risonRequestBody = searchParams.has('requestBody') ? searchParams.get('requestBody') : '()';
  if (!searchParams.has('index')) {
    throw new Error(`Required query parameter 'index' not provided.`);
  }
  const index = searchParams.get('index');
  if (!searchParams.has('geometryFieldName')) {
    throw new Error(`Required query parameter 'geometryFieldName' not provided.`);
  }
  const geometryFieldName = searchParams.get('geometryFieldName');
  const hasLabels = searchParams.has('hasLabels') ? searchParams.get('hasLabels') === 'true' : false;
  if (!searchParams.has('buffer')) {
    throw new Error(`Required query parameter 'buffer' not provided.`);
  }
  const buffer = parseInt(searchParams.get('buffer'), 10);
  if (tileRequest.tileUrl.includes(_constants.MVT_GETGRIDTILE_API_PATH)) {
    return (0, _mvt_request_body.getAggsTileRequest)({
      buffer,
      risonRequestBody,
      geometryFieldName,
      gridPrecision: parseInt(searchParams.get('gridPrecision'), 10),
      hasLabels,
      index,
      renderAs: searchParams.get('renderAs'),
      x: tileRequest.x,
      y: tileRequest.y,
      z: tileRequest.z
    });
  }
  if (tileRequest.tileUrl.includes(_constants.MVT_GETTILE_API_PATH)) {
    return (0, _mvt_request_body.getHitsTileRequest)({
      buffer,
      risonRequestBody,
      geometryFieldName,
      hasLabels,
      index,
      x: tileRequest.x,
      y: tileRequest.y,
      z: tileRequest.z
    });
  }
  throw new Error('Unexpected path');
}