"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticSizeProperty = void 0;
var _static_style_property = require("./static_style_property");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StaticSizeProperty extends _static_style_property.StaticStyleProperty {
  constructor(options, styleName) {
    if (typeof options.size !== 'number') {
      super({
        size: 1
      }, styleName);
    } else {
      super(options, styleName);
    }
  }
  syncHaloWidthWithMb(mbLayerId, mbMap) {
    mbMap.setPaintProperty(mbLayerId, 'icon-halo-width', this._options.size);
  }
  syncIconSizeWithMb(symbolLayerId, mbMap) {
    mbMap.setLayoutProperty(symbolLayerId, 'icon-size', this._options.size / _constants.HALF_MAKI_ICON_SIZE);
  }
  syncCircleStrokeWidthWithMb(mbLayerId, mbMap, hasNoRadius) {
    if (hasNoRadius) {
      mbMap.setPaintProperty(mbLayerId, 'circle-stroke-width', 0);
    } else {
      mbMap.setPaintProperty(mbLayerId, 'circle-stroke-width', this._options.size);
    }
  }
  syncCircleRadiusWithMb(mbLayerId, mbMap) {
    mbMap.setPaintProperty(mbLayerId, 'circle-radius', this._options.size);
  }
  syncLineWidthWithMb(mbLayerId, mbMap) {
    mbMap.setPaintProperty(mbLayerId, 'line-width', this._options.size);
  }
  syncLabelSizeWithMb(mbLayerId, mbMap) {
    mbMap.setLayoutProperty(mbLayerId, 'text-size', this._options.size);
  }
}
exports.StaticSizeProperty = StaticSizeProperty;