"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldItem = void 0;
exports.InnerFieldItem = InnerFieldItem;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/data-views-plugin/common");
var _unifiedFieldList = require("@kbn/unified-field-list");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _public2 = require("@kbn/data-plugin/public");
var _constants = require("../../../common/constants");
var _show_underlying_data = require("../../app_plugin/show_underlying_data");
var _get_field_item_actions = require("./get_field_item_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/common/field_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LazyFieldItemButton = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/unified-field-list'))).then(module => ({
  default: module.FieldItemButton
}))
// unfortunately this force cast is necessary as the lazy load would remove the generic type information
);

// Async load the FieldItemButton component to avoid bundle size increase when inline editing
const WrappedFieldItemButton = props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(LazyFieldItemButton, (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 5
  }
})));
function isTextBasedColumnField(field) {
  return !('type' in field) && Boolean(field === null || field === void 0 ? void 0 : field.meta.type);
}
function InnerFieldItem(props) {
  var _services$data, _services$data$query;
  const {
    query,
    filters,
    field,
    indexPattern,
    highlight,
    exists,
    hideDetails,
    itemIndex,
    groupIndex,
    dropOntoWorkspace,
    hasSuggestionForField,
    editField,
    removeField,
    getCustomFieldType
  } = props;
  const dataViewField = (0, _react.useMemo)(() => {
    // DatatableColumn type
    if (isTextBasedColumnField(field)) {
      var _field$meta$type, _field$meta;
      return new _common.DataViewField({
        name: field.name,
        type: (_field$meta$type = (_field$meta = field.meta) === null || _field$meta === void 0 ? void 0 : _field$meta.type) !== null && _field$meta$type !== void 0 ? _field$meta$type : 'unknown',
        searchable: true,
        aggregatable: true
      });
    }
    // IndexPatternField type
    return new _common.DataViewField(field);
  }, [field]);
  const services = (0, _public.useKibana)().services;
  const filterManager = services === null || services === void 0 ? void 0 : (_services$data = services.data) === null || _services$data === void 0 ? void 0 : (_services$data$query = _services$data.query) === null || _services$data$query === void 0 ? void 0 : _services$data$query.filterManager;
  const [infoIsOpen, setOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => {
    setOpen(value => !value);
  }, [setOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setOpen(false);
  }, [setOpen]);
  const adaptedGetCustomFieldType = (0, _react.useMemo)(() => {
    if (isTextBasedColumnField(field) && getCustomFieldType) {
      return () => getCustomFieldType(field);
    }
    return undefined;
  }, [field, getCustomFieldType]);
  const addFilterAndClose = (0, _react.useMemo)(() => filterManager && indexPattern ? (clickedField, values, operation) => {
    closePopover();
    const newFilters = (0, _public2.generateFilters)(filterManager, clickedField, values, operation, indexPattern);
    filterManager.addFilters(newFilters);
  } : undefined, [indexPattern, filterManager, closePopover]);
  const editFieldAndClose = (0, _react.useMemo)(() => editField && dataViewField.name !== _constants.DOCUMENT_FIELD_NAME ? name => {
    closePopover();
    editField(name);
  } : undefined, [editField, closePopover, dataViewField.name]);
  const removeFieldAndClose = (0, _react.useMemo)(() => removeField ? name => {
    closePopover();
    removeField(name);
  } : undefined, [removeField, closePopover]);
  const indexPatternId = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.id;
  const value = (0, _react.useMemo)(() => isTextBasedColumnField(field) ? {
    field: field.name,
    id: field.id,
    humanData: {
      label: field.name
    }
  } : {
    field,
    indexPatternId,
    id: field.name,
    humanData: {
      label: field.displayName,
      position: itemIndex + 1
    }
  }, [field, indexPatternId, itemIndex]);
  const order = (0, _react.useMemo)(() => [0, groupIndex, itemIndex], [groupIndex, itemIndex]);
  const {
    buttonAddFieldToWorkspaceProps,
    onAddFieldToWorkspace
  } = (0, _get_field_item_actions.getFieldItemActions)({
    value,
    hasSuggestionForField,
    dropOntoWorkspace,
    closeFieldPopover: closePopover
  });
  const commonFieldItemButtonProps = {
    isSelected: false,
    // multiple selections are allowed
    isEmpty: !exists,
    isActive: infoIsOpen,
    withDragIcon: true,
    fieldSearchHighlight: highlight,
    onClick: togglePopover,
    buttonAddFieldToWorkspaceProps,
    onAddFieldToWorkspace
  };
  const renderFooter = (0, _react.useMemo)(() => {
    if (hideDetails || !indexPattern) {
      return;
    }
    if (dataViewField.type === 'geo_point' || dataViewField.type === 'geo_shape') {
      return () => /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldPopoverFooter, {
        field: dataViewField,
        dataView: {
          ...indexPattern,
          toSpec: () => indexPattern.spec
        },
        originatingApp: _constants.APP_ID,
        uiActions: services.uiActions,
        buttonProps: {
          'data-test-subj': `lensVisualize-GeoField-${dataViewField.name}`
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 9
        }
      });
    }
    return function ExplorerInDiscover() {
      const exploreInDiscover = (0, _react.useMemo)(() => getExploreInDiscover({
        query,
        filters,
        indexPattern,
        dataViewField,
        services
      }), []);
      return exploreInDiscover ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fullWidth: true,
        size: "s",
        href: exploreInDiscover,
        target: "_blank",
        "data-test-subj": `lnsFieldListPanel-exploreInDiscover-${dataViewField.name}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.lens.indexPattern.fieldExploreInDiscover', {
        defaultMessage: 'Explore in Discover'
      }))) : null;
    };
  }, [dataViewField, filters, hideDetails, indexPattern, query, services]);
  return /*#__PURE__*/_react.default.createElement("li", {
    "data-attr-field": field.name,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldPopover, {
    isOpen: infoIsOpen,
    closePopover: closePopover,
    panelClassName: "lnsFieldItem__fieldPanel",
    panelStyle: {
      minWidth: '260px',
      maxWidth: '300px'
    },
    initialFocus: ".lnsFieldItem__fieldPanel",
    "data-test-subj": "lnsFieldListPanelField",
    panelProps: {
      'data-test-subj': 'lnsFieldListPanelFieldContent'
    },
    container: document.querySelector('.application') || undefined,
    button: /*#__PURE__*/_react.default.createElement(_domDragDrop.Draggable, {
      dragType: "copy",
      value: value,
      order: order,
      onDragStart: closePopover,
      dataTestSubj: `lnsFieldListPanelField-${field.name}`,
      dragClassName: "unifiedFieldListItemButton__dragging",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 11
      }
    }, isTextBasedColumnField(field) ? /*#__PURE__*/_react.default.createElement(WrappedFieldItemButton, (0, _extends2.default)({
      field: field,
      getCustomFieldType: getCustomFieldType
    }, commonFieldItemButtonProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 15
      }
    })) : /*#__PURE__*/_react.default.createElement(WrappedFieldItemButton, (0, _extends2.default)({
      field: field
    }, commonFieldItemButtonProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 15
      }
    }))),
    renderHeader: () => {
      return /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldPopoverHeader, {
        field: dataViewField,
        closePopover: closePopover,
        buttonAddFieldToWorkspaceProps: buttonAddFieldToWorkspaceProps,
        getCustomFieldType: adaptedGetCustomFieldType,
        onAddFieldToWorkspace: onAddFieldToWorkspace,
        onAddFilter: addFilterAndClose,
        onEditField: editFieldAndClose,
        onDeleteField: removeFieldAndClose,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 310,
          columnNumber: 13
        }
      });
    },
    renderContent: !hideDetails ? () => /*#__PURE__*/_react.default.createElement(FieldItemPopoverContents, (0, _extends2.default)({}, props, {
      dataViewField: dataViewField,
      onAddFilter: addFilterAndClose,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 17
      }
    })) : undefined,
    renderFooter: renderFooter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 7
    }
  }));
}
const FieldItem = exports.FieldItem = /*#__PURE__*/_react.default.memo(InnerFieldItem);
function FieldItemPopoverContents(props) {
  const {
    query,
    filters,
    indexPattern,
    dataViewField,
    dateRange,
    onAddFilter
  } = props;
  const services = (0, _public.useKibana)().services;
  if (!indexPattern) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_unifiedFieldList.FieldStats, {
    services: services,
    query: query,
    filters: filters,
    fromDate: dateRange.fromDate,
    toDate: dateRange.toDate,
    dataViewOrDataViewId: indexPattern.id // TODO: Refactor to pass a variable with DataView type instead of IndexPattern
    ,
    onAddFilter: onAddFilter,
    field: dataViewField,
    "data-test-subj": "lnsFieldListPanel",
    overrideMissingContent: params => {
      if (params.reason === 'no-data') {
        // TODO: should we replace this with a default message "Analysis is not available for this field?"
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          "data-test-subj": "lnsFieldListPanel-missingFieldStats",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 369,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.lens.indexPattern.fieldStatsNoData', {
          defaultMessage: 'Lens is unable to create visualizations with this field because it does not contain data. To create a visualization, drag and drop a different field.'
        }));
      }
      if (params.reason === 'unsupported') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          "data-test-subj": "lnsFieldListPanel-missingFieldStats",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 379,
            columnNumber: 13
          }
        }, params.element);
      }
      return params.element;
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 5
    }
  });
}
function getExploreInDiscover({
  query,
  filters,
  indexPattern,
  dataViewField,
  services
}) {
  var _services$share;
  const meta = {
    id: indexPattern.id,
    columns: [dataViewField.name],
    filters: {
      enabled: {
        lucene: [],
        kuery: []
      },
      disabled: {
        lucene: [],
        kuery: []
      }
    }
  };
  const {
    filters: newFilters,
    query: newQuery
  } = (0, _show_underlying_data.combineQueryAndFilters)(query, filters, meta, [indexPattern], (0, _public2.getEsQueryConfig)(services.uiSettings));
  const discoverLocator = (_services$share = services.share) === null || _services$share === void 0 ? void 0 : _services$share.url.locators.get('DISCOVER_APP_LOCATOR');
  if (!discoverLocator || !services.application.capabilities.discover_v2.show) {
    return;
  }
  return discoverLocator.getRedirectUrl({
    dataViewSpec: indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.spec,
    timeRange: services.data.query.timefilter.timefilter.getTime(),
    filters: newFilters,
    query: newQuery,
    columns: meta.columns
  });
}