"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListControlEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _index_pattern_select_form_row = require("./index_pattern_select_form_row");
var _field_select = require("./field_select");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/input_control_vis/public/components/editor/list_control_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function filterField(field) {
  return Boolean(field.aggregatable) && ['number', 'boolean', 'date', 'ip', 'string'].includes(field.type);
}
class ListControlEditor extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isLoadingFieldType: true,
      isStringField: false,
      prevFieldName: this.props.controlParams.fieldName,
      IndexPatternSelect: null
    });
    (0, _defineProperty2.default)(this, "componentDidUpdate", () => {
      if (this.state.isLoadingFieldType) {
        this.loadIsStringField();
      }
    });
    (0, _defineProperty2.default)(this, "loadIsStringField", async () => {
      if (!this.props.controlParams.indexPattern || !this.props.controlParams.fieldName) {
        this.setState({
          isLoadingFieldType: false
        });
        return;
      }
      let indexPattern;
      try {
        indexPattern = await this.props.getIndexPattern(this.props.controlParams.indexPattern);
      } catch (err) {
        // index pattern no longer exists
        return;
      }
      if (!this.isMounted) {
        return;
      }
      const field = indexPattern.fields.find(({
        name
      }) => name === this.props.controlParams.fieldName);
      if (!field) {
        return;
      }
      this.setState({
        isLoadingFieldType: false,
        isStringField: field.type === 'string'
      });
    });
    (0, _defineProperty2.default)(this, "renderOptions", () => {
      var _this$props$controlPa, _this$props$controlPa2;
      if (this.state.isLoadingFieldType || !this.props.controlParams.fieldName) {
        return;
      }
      const options = [];
      if (this.props.parentCandidates && this.props.parentCandidates.length > 0) {
        const parentCandidatesOptions = [{
          value: '',
          text: ''
        }, ...this.props.parentCandidates];
        options.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          id: `parentSelect-${this.props.controlIndex}`,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "inputControl.editor.listControl.parentLabel",
            defaultMessage: "Parent control",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 146,
              columnNumber: 13
            }
          }),
          helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "inputControl.editor.listControl.parentDescription",
            defaultMessage: "Options are based on the value of parent control. Disabled if parent is not set.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 152,
              columnNumber: 13
            }
          }),
          key: "parentSelect",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 143,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
          options: parentCandidatesOptions,
          value: this.props.controlParams.parent,
          onChange: event => {
            this.props.handleParentChange(this.props.controlIndex, event.target.value);
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 159,
            columnNumber: 11
          }
        })));
      }
      options.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        id: `multiselect-${this.props.controlIndex}`,
        key: "multiselect",
        helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "inputControl.editor.listControl.multiselectDescription",
          defaultMessage: "Allow multiple selection",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 175,
            columnNumber: 11
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "inputControl.editor.listControl.multiselectLabel",
          defaultMessage: "Multiselect",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 183,
            columnNumber: 13
          }
        }),
        checked: (_this$props$controlPa = this.props.controlParams.options.multiselect) !== null && _this$props$controlPa !== void 0 ? _this$props$controlPa : true,
        onChange: event => {
          this.props.handleOptionsChange(this.props.controlIndex, 'multiselect', event.target.checked);
        },
        "data-test-subj": "listControlMultiselectInput",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 9
        }
      })));
      const dynamicOptionsHelpText = this.state.isStringField ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inputControl.editor.listControl.dynamicOptions.updateDescription",
        defaultMessage: "Update options in response to user input",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 7
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inputControl.editor.listControl.dynamicOptions.stringFieldDescription",
        defaultMessage: "Only available for \"string\" fields",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 7
        }
      });
      options.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        id: `dynamicOptions-${this.props.controlIndex}`,
        key: "dynamicOptions",
        helpText: dynamicOptionsHelpText,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "inputControl.editor.listControl.dynamicOptionsLabel",
          defaultMessage: "Dynamic Options",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 220,
            columnNumber: 13
          }
        }),
        checked: (_this$props$controlPa2 = this.props.controlParams.options.dynamicOptions) !== null && _this$props$controlPa2 !== void 0 ? _this$props$controlPa2 : false,
        onChange: event => {
          this.props.handleOptionsChange(this.props.controlIndex, 'dynamicOptions', event.target.checked);
        },
        disabled: this.state.isStringField ? false : true,
        "data-test-subj": "listControlDynamicOptionsSwitch",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 9
        }
      })));

      // size is not used when dynamic options is set
      if (!this.props.controlParams.options.dynamicOptions || !this.state.isStringField) {
        options.push(/*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          id: `size-${this.props.controlIndex}`,
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "inputControl.editor.listControl.sizeLabel",
            defaultMessage: "Size",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 245,
              columnNumber: 13
            }
          }),
          key: "size",
          helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "inputControl.editor.listControl.sizeDescription",
            defaultMessage: "Number of options",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 252,
              columnNumber: 13
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 242,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
          min: 1,
          value: this.props.controlParams.options.size,
          onChange: event => {
            this.props.handleOptionsChange(this.props.controlIndex, 'size', event.target.valueAsNumber);
          },
          "data-test-subj": "listControlSizeInput",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 258,
            columnNumber: 11
          }
        })));
      }
      return options;
    });
  }
  componentDidMount() {
    this.isMounted = true;
    this.loadIsStringField();
    this.getIndexPatternSelect();
  }
  componentWillUnmount() {
    this.isMounted = false;
  }
  async getIndexPatternSelect() {
    const [, {
      unifiedSearch
    }] = await this.props.deps.core.getStartServices();
    this.setState({
      IndexPatternSelect: unifiedSearch.ui.IndexPatternSelect
    });
  }
  render() {
    if (this.state.IndexPatternSelect === null) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_index_pattern_select_form_row.IndexPatternSelectFormRow, {
      indexPatternId: this.props.controlParams.indexPattern,
      onChange: this.props.handleIndexPatternChange,
      controlIndex: this.props.controlIndex,
      IndexPatternSelect: this.state.IndexPatternSelect,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
      fieldName: this.props.controlParams.fieldName,
      indexPatternId: this.props.controlParams.indexPattern,
      filterField: filterField,
      onChange: this.props.handleFieldNameChange,
      getIndexPattern: this.props.getIndexPattern,
      controlIndex: this.props.controlIndex,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 9
      }
    }), this.renderOptions());
  }
}
exports.ListControlEditor = ListControlEditor;
(0, _defineProperty2.default)(ListControlEditor, "getDerivedStateFromProps", (nextProps, prevState) => {
  const isNewFieldName = prevState.prevFieldName !== nextProps.controlParams.fieldName;
  if (!prevState.isLoadingFieldType && isNewFieldName) {
    return {
      prevFieldName: nextProps.controlParams.fieldName,
      isLoadingFieldType: true
    };
  }
  return null;
});