"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlsContent = void 0;
var _public = require("@kbn/controls-plugin/public");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public2 = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _use_time_range_metadata = require("../../../../../hooks/use_time_range_metadata");
var _schema_selector = require("../../../../../components/schema_selector");
var _control_panels_config = require("./control_panels_config");
var _controls_title = require("./controls_title");
var _use_unified_search = require("../../hooks/use_unified_search");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/search_bar/controls_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ControlsContent = ({
  dataView,
  filters,
  query,
  timeRange,
  schema,
  onFiltersChange,
  schemas
}) => {
  const controlConfigs = (0, _react.useMemo)(() => (0, _control_panels_config.getControlPanelConfigs)(schema), [schema]);
  const [controlPanels, setControlPanels] = (0, _public2.useControlPanels)(controlConfigs.controls, dataView);
  const controlGroupAPI = (0, _react.useRef)();
  const subscriptions = (0, _react.useRef)(new _rxjs.Subscription());
  const {
    onPreferredSchemaChange
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    status
  } = (0, _use_time_range_metadata.useTimeRangeMetadataContext)();
  const isLoading = (0, _use_fetcher.isPending)(status);
  const getInitialInput = (0, _react.useCallback)(async () => {
    const initialInput = {
      chainingSystem: 'HIERARCHICAL',
      labelPosition: 'oneLine',
      initialChildControlState: controlPanels
    };
    return {
      initialState: initialInput
    };
  }, [controlPanels]);
  (0, _react.useEffect)(() => {
    const current = controlGroupAPI.current;
    if (!current || !controlConfigs.replace) {
      return;
    }
    Object.entries(controlConfigs.replace).forEach(([key, replaceable]) => {
      current.replacePanel(key, {
        panelType: replaceable.control.type,
        maybePanelId: replaceable.key,
        serializedState: {
          rawState: {
            ...replaceable.control,
            dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
          }
        }
      });
    });
  }, [schema, controlConfigs, dataView === null || dataView === void 0 ? void 0 : dataView.id]);
  const loadCompleteHandler = (0, _react.useCallback)(controlGroup => {
    if (!controlGroup) return;
    controlGroupAPI.current = controlGroup;
    controlGroup.untilInitialized().then(() => {
      subscriptions.current.add(controlGroup.children$.subscribe(children => {
        Object.keys(children).map(childId => {
          const child = children[childId];
          child.CustomPrependComponent = () => /*#__PURE__*/_react.default.createElement(_controls_title.ControlTitle, {
            title: child.title$.getValue(),
            embeddableId: childId,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 100,
              columnNumber: 17
            }
          });
        });
      }));
    });
    subscriptions.current.add(controlGroup.filters$.subscribe((newFilters = []) => {
      onFiltersChange(newFilters);
    }));
    subscriptions.current.add(controlGroup.getInput$().subscribe(({
      initialChildControlState
    }) => setControlPanels(initialChildControlState)));
  }, [onFiltersChange, setControlPanels]);
  (0, _react.useEffect)(() => {
    const currentSubscriptions = subscriptions.current;
    return () => {
      currentSubscriptions.unsubscribe();
    };
  }, []);
  if (!dataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ControlGroupContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ControlGroupRenderer, {
    getCreationOptions: getInitialInput,
    onApiAvailable: loadCompleteHandler,
    timeRange: timeRange,
    query: query,
    filters: filters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_schema_selector.SchemaSelector, {
    isHostsView: true,
    onChange: onPreferredSchemaChange,
    schemas: schemas,
    value: schema !== null && schema !== void 0 ? schema : 'semconv',
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }));
};
exports.ControlsContent = ControlsContent;
const ControlGroupContainer = _styled.default.div`
  .controlGroup {
    min-height: ${props => props.theme.euiTheme.size.xxl};
    align-items: start;
    margin-bottom: ${props => props.theme.euiTheme.size.s};
  }
`;