"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareMountElement = void 0;
var _public = require("@kbn/core/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const prepareMountElement = (element, testSubject) => {
  // Ensure all wrapping elements have the APP_WRAPPER_CLASS so that the KinanaPageTemplate works as expected
  element.classList.add(_public.APP_WRAPPER_CLASS);
  if (testSubject) {
    element.setAttribute('data-test-subj', testSubject);
  }
};
exports.prepareMountElement = prepareMountElement;