"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRedirectPath = useRedirectPath;
var _react = require("react");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRedirectPath(history) {
  const {
    services
  } = (0, _.useKibana)();
  const redirectPath = (0, _react.useMemo)(() => {
    const locationSearchParams = new URLSearchParams(history.location.search);
    return locationSearchParams.get('redirect_path');
  }, [history.location.search]);
  return (0, _react.useCallback)(location => {
    if (redirectPath && services.application) {
      services.application.navigateToUrl(redirectPath);
    } else {
      history.push(location);
    }
  }, [redirectPath, services.application, history]);
}