"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGlobalFields = exports.globalFields = exports.GlobalFieldsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/form/global_fields_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Those are the fields that we always want present in our form.
 */

const GlobalFieldsContext = /*#__PURE__*/(0, _react.createContext)(null);
const globalFields = exports.globalFields = {
  deleteEnabled: {
    path: '_meta.delete.enabled'
  },
  searchableSnapshotRepo: {
    path: '_meta.searchableSnapshot.repository'
  },
  warmMinAgeMilliSeconds: {
    path: '_meta.warm.minAgeToMilliSeconds'
  },
  coldMinAgeMilliSeconds: {
    path: '_meta.cold.minAgeToMilliSeconds'
  },
  frozenMinAgeMilliSeconds: {
    path: '_meta.frozen.minAgeToMilliSeconds'
  },
  deleteMinAgeMilliSeconds: {
    path: '_meta.delete.minAgeToMilliSeconds'
  },
  hotIsUsingShardSize: {
    path: '_meta.hot.shrink.isUsingShardSize'
  },
  warmIsUsingShardSize: {
    path: '_meta.warm.shrink.isUsingShardSize'
  }
};
const GlobalFieldsProvider = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: globalFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, fields => {
    return /*#__PURE__*/_react.default.createElement(GlobalFieldsContext.Provider, {
      value: fields,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 11
      }
    }, children);
  });
};
exports.GlobalFieldsProvider = GlobalFieldsProvider;
const useGlobalFields = () => {
  const ctx = (0, _react.useContext)(GlobalFieldsContext);
  if (!ctx) throw new Error('Cannot use global fields outside of global fields context');
  return ctx;
};
exports.useGlobalFields = useGlobalFields;