"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.packagePolicyHasOtelInputs = exports.packageInfoHasOtelInputs = exports.OTEL_INPUTS_MINIMUM_VERSION = void 0;
var _constants = require("../constants");
var _policy_template = require("./policy_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OTEL_INPUTS_MINIMUM_VERSION = exports.OTEL_INPUTS_MINIMUM_VERSION = '9.2.0';
const packageInfoHasOtelInputs = packageInfo => ((packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.policy_templates) || []).some(template => (0, _policy_template.isInputOnlyPolicyTemplate)(template) && template.input === _constants.OTEL_COLLECTOR_INPUT_TYPE);
exports.packageInfoHasOtelInputs = packageInfoHasOtelInputs;
const packagePolicyHasOtelInputs = packagePolicyInputs => (packagePolicyInputs || []).some(input => input.type === _constants.OTEL_COLLECTOR_INPUT_TYPE && input.enabled);
exports.packagePolicyHasOtelInputs = packagePolicyHasOtelInputs;