"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocationFromCommandOrOptionName = void 0;
var _types = require("@kbn/esql-ast/src/commands_registry/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal **/

/**
 *  Partial fields metadata client, used to avoid circular dependency with @kbn/monaco
/** @internal **/

const commandOptionNameToLocation = {
  eval: _types.Location.EVAL,
  where: _types.Location.WHERE,
  row: _types.Location.ROW,
  sort: _types.Location.SORT,
  stats: _types.Location.STATS,
  by: _types.Location.STATS_BY,
  enrich: _types.Location.ENRICH,
  with: _types.Location.ENRICH_WITH,
  on: _types.Location.RERANK,
  dissect: _types.Location.DISSECT,
  rename: _types.Location.RENAME,
  join: _types.Location.JOIN,
  show: _types.Location.SHOW,
  completion: _types.Location.COMPLETION,
  rerank: _types.Location.RERANK
};

/**
 * Pause before using this in new places. Where possible, use the Location enum directly.
 *
 * This is primarily around for backwards compatibility with the old system of command and option names.
 */
const getLocationFromCommandOrOptionName = name => commandOptionNameToLocation[name];
exports.getLocationFromCommandOrOptionName = getLocationFromCommandOrOptionName;