"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderHeaderActions = exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRedux = require("react-redux");
var _kea = require("kea");
var _rxjs = require("rxjs");
var _cellActions = require("@kbn/cell-actions");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _flash_messages = require("./shared/flash_messages");
var _http = require("./shared/http");
var _kibana = require("./shared/kibana");
var _licensing = require("./shared/licensing");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * This file serves as a reusable wrapper to share Kibana-level context and other helpers
 * between various Enterprise Search plugins (e.g. AppSearch, WorkplaceSearch, ES landing page)
 * which should be imported and passed in as the first param in plugin.ts.
 */

const renderApp = (App, {
  params,
  core,
  plugins,
  isSidebarEnabled = true,
  updateSideNavDefinition
}, {
  config,
  data,
  esConfig
}) => {
  var _plugins$contentConne, _core$application$cap, _core$application$cap2, _plugins$licensing;
  const {
    errorConnectingMessage,
    features,
    kibanaVersion
  } = data;
  const {
    history
  } = params;
  const {
    application,
    chrome,
    http,
    notifications,
    uiSettings
  } = core;
  const {
    capabilities,
    navigateToUrl
  } = application;
  const {
    charts,
    cloud,
    indexManagement: indexManagementPlugin,
    lens,
    security,
    share,
    ml,
    fleet,
    uiActions,
    searchNavigation
  } = plugins;
  const productFeatures = features !== null && features !== void 0 ? features : {
    ..._constants.DEFAULT_PRODUCT_FEATURES
  };
  const EmptyContext = ({
    children
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  const CloudContext = (cloud === null || cloud === void 0 ? void 0 : cloud.CloudContextProvider) || EmptyContext;
  (0, _kea.resetContext)({
    createStore: true
  });
  const store = (0, _kea.getContext)().store;
  const indexMappingComponent = indexManagementPlugin === null || indexManagementPlugin === void 0 ? void 0 : indexManagementPlugin.getIndexMappingComponent({
    history
  });
  const connectorTypes = ((_plugins$contentConne = plugins.contentConnectors) === null || _plugins$contentConne === void 0 ? void 0 : _plugins$contentConne.getConnectorTypes()) || [];
  const unmountKibanaLogic = (0, _kibana.mountKibanaLogic)({
    application,
    capabilities,
    charts,
    cloud,
    config,
    connectorTypes,
    console: plugins.console,
    coreSecurity: core.security,
    data: plugins.data,
    esConfig,
    fleet,
    getChromeStyle$: chrome.getChromeStyle$,
    getNavLinks: chrome.navLinks.getAll,
    history,
    indexMappingComponent,
    isSidebarEnabled,
    kibanaVersion,
    lens,
    ml,
    navigateToUrl,
    productFeatures,
    renderHeaderActions: HeaderActions => params.setHeaderActionMenu(HeaderActions ? renderHeaderActions.bind(null, HeaderActions, store, params) : undefined),
    searchNavigation,
    security,
    setBreadcrumbs: chrome.setBreadcrumbs,
    setChromeIsVisible: chrome.setIsVisible,
    setDocTitle: chrome.docTitle.change,
    share,
    uiActions,
    uiSettings,
    updateSideNavDefinition
  });
  const unmountLicensingLogic = (0, _licensing.mountLicensingLogic)({
    canManageLicense: (_core$application$cap = core.application.capabilities.management) === null || _core$application$cap === void 0 ? void 0 : (_core$application$cap2 = _core$application$cap.stack) === null || _core$application$cap2 === void 0 ? void 0 : _core$application$cap2.license_management,
    license$: ((_plugins$licensing = plugins.licensing) === null || _plugins$licensing === void 0 ? void 0 : _plugins$licensing.license$) || (0, _rxjs.of)(undefined)
  });
  const unmountHttpLogic = (0, _http.mountHttpLogic)({
    errorConnectingMessage,
    http
  });
  const unmountFlashMessagesLogic = (0, _flash_messages.mountFlashMessagesLogic)({
    notifications
  });
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$: params.theme$
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: core.theme.getTheme().darkMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: plugins.uiActions.getTriggerCompatibleActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(CloudContext, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: params.history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(App, {
    features: features,
    kibanaVersion: kibanaVersion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 21
    }
  }))))))))), params.element);
  return () => {
    var _plugins$data;
    _reactDom.default.unmountComponentAtNode(params.element);
    unmountKibanaLogic();
    unmountLicensingLogic();
    unmountHttpLogic();
    unmountFlashMessagesLogic();
    (_plugins$data = plugins.data) === null || _plugins$data === void 0 ? void 0 : _plugins$data.search.session.clear();
  };
};

/**
 * Render function for Kibana's header action menu chrome -
 * reusable by any Enterprise Search plugin simply by passing in
 * a custom HeaderActions component (e.g., WorkplaceSearchHeaderActions)
 * @see https://github.com/elastic/kibana/blob/8.0/docs/development/core/public/kibana-plugin-core-public.appmountparameters.setheaderactionmenu.md
 */
exports.renderApp = renderApp;
const renderHeaderActions = (HeaderActions, store, params, kibanaHeaderEl) => {
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$: params.theme$
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(HeaderActions, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  })))), kibanaHeaderEl);
  return () => _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), kibanaHeaderEl);
};
exports.renderHeaderActions = renderHeaderActions;