"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnonymizedEvents = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _retrievers = require("./retrievers");
var _enrichers = require("./enrichers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnonymizedEvents = async ({
  insightType,
  endpointIds,
  anonymizationFields,
  esClient,
  kbDataClient,
  onNewReplacements,
  replacements,
  size,
  start,
  end
}) => {
  if (insightType == null) {
    return [];
  }
  const events = await (0, _retrievers.getEventsForInsightType)(insightType, esClient, {
    endpointIds,
    size,
    gte: start,
    lte: end
  });
  const enrichedEvents = await (0, _enrichers.enrichEvents)(insightType, events, {
    kbDataClient
  });
  let localReplacements = {
    ...(replacements !== null && replacements !== void 0 ? replacements : {})
  };
  const localOnNewReplacements = newReplacements => {
    localReplacements = {
      ...localReplacements,
      ...newReplacements
    };
    onNewReplacements === null || onNewReplacements === void 0 ? void 0 : onNewReplacements(localReplacements); // invoke the callback with the latest replacements
  };
  return enrichedEvents.map(event => (0, _elasticAssistantCommon.transformRawData)({
    anonymizationFields,
    currentReplacements: localReplacements,
    // <-- the latest local replacements
    getAnonymizedValue: _elasticAssistantCommon.getAnonymizedValue,
    onNewReplacements: localOnNewReplacements,
    // <-- the local callback
    rawData: (0, _elasticAssistantCommon.getRawDataOrDefault)(event)
  }));
};
exports.getAnonymizedEvents = getAnonymizedEvents;