"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataUsageMetrics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _charts = require("./charts");
var _use_breadcrumbs = require("../../utils/use_breadcrumbs");
var _use_kibana = require("../../utils/use_kibana");
var _rest_types = require("../../../common/rest_types");
var _translations = require("../../translations");
var _use_get_usage_metrics = require("../../hooks/use_get_usage_metrics");
var _use_get_data_streams = require("../../hooks/use_get_data_streams");
var _use_charts_url_params = require("../hooks/use_charts_url_params");
var _utils = require("../../../common/utils");
var _use_date_picker = require("../hooks/use_date_picker");
var _charts_filters = require("./filters/charts_filters");
var _charts_loading = require("./charts_loading");
var _no_data_callout = require("./no_data_callout");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_usage/public/app/components/data_usage_metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EuiItemCss = (0, _react2.css)`
  width: 100%;
`;
const FlexItemWithCss = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  css: EuiItemCss,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
}, children);
const DataUsageMetrics = exports.DataUsageMetrics = /*#__PURE__*/(0, _react.memo)(({
  'data-test-subj': dataTestSubj = 'data-usage-metrics'
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const [isFirstPageLoad, setIsFirstPageLoad] = (0, _react.useState)(true);
  const {
    services: {
      chrome,
      appParams,
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: _translations.PLUGIN_NAME
  }], appParams, chrome);
  const {
    metricTypes: metricTypesFromUrl,
    dataStreams: dataStreamsFromUrl,
    startDate: startDateFromUrl,
    endDate: endDateFromUrl,
    setUrlMetricTypesFilter,
    setUrlDataStreamsFilter,
    setUrlDateRangeFilter
  } = (0, _use_charts_url_params.useDataUsageMetricsUrlParams)();
  const {
    error: errorFetchingDataStreams,
    data: dataStreams,
    isFetching: isFetchingDataStreams
  } = (0, _use_get_data_streams.useGetDataUsageDataStreams)({
    selectedDataStreams: dataStreamsFromUrl,
    options: {
      enabled: true,
      retry: false
    }
  });
  const [metricsFilters, setMetricsFilters] = (0, _react.useState)({
    metricTypes: [..._rest_types.DEFAULT_METRIC_TYPES],
    dataStreams: [],
    from: _utils.DEFAULT_DATE_RANGE_OPTIONS.startDate,
    to: _utils.DEFAULT_DATE_RANGE_OPTIONS.endDate
  });
  (0, _react.useEffect)(() => {
    if (!metricTypesFromUrl && isFirstPageLoad) {
      setUrlMetricTypesFilter(metricsFilters.metricTypes.join(','));
    }
    if (!dataStreamsFromUrl && !!dataStreams && dataStreams.length > 0 && isFirstPageLoad) {
      const hasMoreThan50 = dataStreams.length > 50;
      const _dataStreams = hasMoreThan50 ? dataStreams.slice(0, 50) : dataStreams;
      setUrlDataStreamsFilter(_dataStreams.map(ds => ds.name).join(','));
    }
    if (!startDateFromUrl || !endDateFromUrl) {
      setUrlDateRangeFilter({
        startDate: metricsFilters.from,
        endDate: metricsFilters.to
      });
    }
  }, [dataStreams, dataStreamsFromUrl, endDateFromUrl, isFirstPageLoad, metricTypesFromUrl, metricsFilters.dataStreams, metricsFilters.from, metricsFilters.metricTypes, metricsFilters.to, setUrlDataStreamsFilter, setUrlDateRangeFilter, setUrlMetricTypesFilter, startDateFromUrl]);
  (0, _react.useEffect)(() => {
    setMetricsFilters(prevState => ({
      ...prevState,
      metricTypes: metricTypesFromUrl !== null && metricTypesFromUrl !== void 0 && metricTypesFromUrl.length ? metricTypesFromUrl : prevState.metricTypes,
      dataStreams: dataStreamsFromUrl !== null && dataStreamsFromUrl !== void 0 && dataStreamsFromUrl.length ? dataStreamsFromUrl : prevState.dataStreams,
      from: startDateFromUrl !== null && startDateFromUrl !== void 0 ? startDateFromUrl : prevState.from,
      to: endDateFromUrl !== null && endDateFromUrl !== void 0 ? endDateFromUrl : prevState.to
    }));
  }, [metricTypesFromUrl, dataStreamsFromUrl, startDateFromUrl, endDateFromUrl]);
  const {
    dateRangePickerState,
    isValidDateRange,
    onRefreshChange,
    onTimeChange
  } = (0, _use_date_picker.useDateRangePicker)();
  const enableFetchUsageMetricsData = (0, _react.useMemo)(() => isValidDateRange && metricsFilters.dataStreams.length > 0 && metricsFilters.metricTypes.length > 0, [isValidDateRange, metricsFilters.dataStreams, metricsFilters.metricTypes]);
  const utcTimeRange = (0, _react.useMemo)(() => (0, _utils.transformToUTCtime)({
    start: dateRangePickerState.startDate,
    end: dateRangePickerState.endDate,
    isISOString: true
  }), [dateRangePickerState]);
  const {
    error: errorFetchingDataUsageMetrics,
    data: usageMetricsData,
    isFetching,
    isFetched: hasFetchedDataUsageMetricsData,
    refetch: refetchDataUsageMetrics
  } = (0, _use_get_usage_metrics.useGetDataUsageMetrics)({
    ...metricsFilters,
    from: utcTimeRange.start,
    to: utcTimeRange.end
  }, {
    retry: false,
    enabled: enableFetchUsageMetricsData
  });
  (0, _react.useEffect)(() => {
    if (!isFetching && hasFetchedDataUsageMetricsData) {
      setIsFirstPageLoad(false);
    }
  }, [isFetching, hasFetchedDataUsageMetricsData]);
  const onRefresh = (0, _react.useCallback)(() => {
    if (!enableFetchUsageMetricsData) {
      return;
    }
    refetchDataUsageMetrics();
  }, [enableFetchUsageMetricsData, refetchDataUsageMetrics]);
  const onChangeDataStreamsFilter = (0, _react.useCallback)(selectedDataStreams => {
    setMetricsFilters(prevState => ({
      ...prevState,
      dataStreams: selectedDataStreams
    }));
  }, [setMetricsFilters]);
  const onChangeMetricTypesFilter = (0, _react.useCallback)(selectedMetricTypes => {
    setMetricsFilters(prevState => ({
      ...prevState,
      metricTypes: selectedMetricTypes
    }));
  }, [setMetricsFilters]);
  const filterOptions = (0, _react.useMemo)(() => {
    const dataStreamsOptions = dataStreams === null || dataStreams === void 0 ? void 0 : dataStreams.reduce((acc, ds) => {
      acc[ds.name] = ds.storageSizeBytes;
      return acc;
    }, {});
    return {
      dataStreams: {
        filterName: 'dataStreams',
        options: dataStreamsOptions ? Object.keys(dataStreamsOptions) : metricsFilters.dataStreams,
        appendOptions: dataStreamsOptions,
        selectedOptions: metricsFilters.dataStreams,
        onChangeFilterOptions: onChangeDataStreamsFilter,
        isFilterLoading: isFetchingDataStreams
      },
      metricTypes: {
        filterName: 'metricTypes',
        options: metricsFilters.metricTypes,
        onChangeFilterOptions: onChangeMetricTypesFilter
      }
    };
  }, [dataStreams, isFetchingDataStreams, metricsFilters.dataStreams, metricsFilters.metricTypes, onChangeDataStreamsFilter, onChangeMetricTypesFilter]);
  if (errorFetchingDataUsageMetrics) {
    notifications.toasts.addDanger({
      title: _i18n.i18n.translate('xpack.dataUsage.getMetrics.addFailure.toast.title', {
        defaultMessage: 'Error getting usage metrics'
      }),
      text: errorFetchingDataUsageMetrics.message
    });
  }
  if (errorFetchingDataStreams) {
    notifications.toasts.addDanger({
      title: _i18n.i18n.translate('xpack.dataUsage.getDataStreams.addFailure.toast.title', {
        defaultMessage: 'Error getting data streams'
      }),
      text: errorFetchingDataStreams.message
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(FlexItemWithCss, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts_filters.ChartsFilters, {
    dateRangePickerState: dateRangePickerState,
    isDataLoading: isFetchingDataStreams,
    isUpdateDisabled: !enableFetchUsageMetricsData,
    isValidDateRange: isValidDateRange,
    onClick: refetchDataUsageMetrics,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    onTimeChange: onTimeChange,
    filterOptions: filterOptions,
    showMetricsTypesFilter: false,
    "data-test-subj": getTestId('filter'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(FlexItemWithCss, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  }, hasFetchedDataUsageMetricsData && usageMetricsData ? /*#__PURE__*/_react.default.createElement(_charts.Charts, {
    data: usageMetricsData,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 13
    }
  }) : isFetching ? /*#__PURE__*/_react.default.createElement(_charts_loading.ChartsLoading, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_no_data_callout.NoDataCallout, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 13
    }
  })));
});