"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlClone = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _classnames = _interopRequireDefault(require("classnames"));
var _controlsConstants = require("@kbn/controls-constants");
var _control_panel = require("./control_panel.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/control_group/components/control_clone.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * A simplified clone version of the control which is dragged. This version only shows
 * the title, because individual controls can be any size, and dragging a wide item
 * can be quite cumbersome.
 */
const ControlClone = ({
  labelPosition,
  controlApi
}) => {
  const [width, panelTitle, defaultPanelTitle] = (0, _presentationPublishing.useBatchedPublishingSubjects)(controlApi ? controlApi.width$ : new _rxjs.BehaviorSubject(_controlsConstants.DEFAULT_CONTROL_GROW), controlApi !== null && controlApi !== void 0 && controlApi.title$ ? controlApi.title$ : new _rxjs.BehaviorSubject(undefined), controlApi !== null && controlApi !== void 0 && controlApi.defaultTitle$ ? controlApi.defaultTitle$ : new _rxjs.BehaviorSubject(''));
  const isTwoLine = labelPosition === 'twoLine';
  const styles = (0, _use_memo_css.useMemoCss)(controlCloneStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.container,
    className: (0, _classnames.default)({
      'controlFrameWrapper--medium': width === 'medium',
      'controlFrameWrapper--small': width === 'small',
      'controlFrameWrapper--large': width === 'large'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, isTwoLine && /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 21
    }
  }, panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    css: styles.dragContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grabHorizontal",
    css: styles.grabIcon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  })), !isTwoLine && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("label", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle))));
};
exports.ControlClone = ControlClone;
const controlCloneStyles = {
  container: context => [(0, _react2.css)({
    width: 'max-content'
  }), (0, _control_panel.controlWidthStyles)(context)],
  grabIcon: (0, _react2.css)({
    cursor: 'grabbing'
  }),
  dragContainer: context => (0, _react2.css)([{
    cursor: 'grabbing',
    height: context.euiTheme.size.xl,
    alignItems: 'center',
    borderRadius: context.euiTheme.border.radius.medium,
    fontWeight: context.euiTheme.font.weight.bold,
    border: `${context.euiTheme.border.width.thin} solid ${context.euiTheme.colors.borderBasePlain}`,
    minWidth: `calc(${context.euiTheme.size.base} * 14)`,
    backgroundColor: context.euiTheme.colors.backgroundBaseFormsPrepend
  }, (0, _eui.euiFontSize)(context, 'xs')])
};