"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncsContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _cancel_syncs_api_logic = require("../../../api/connector/cancel_syncs_api_logic");
var _connector_view_logic = require("../../connector_detail/connector_view_logic");
var _index_view_logic = require("../../search_index/index_view_logic");
var _syncs_logic = require("./syncs_logic");
var _app_context = require("../../../app_context");
var _api = require("../../../../common/types/api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/shared/header_actions/syncs_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SyncsContextMenu = ({
  disabled = false
}) => {
  var _connector$configurat;
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    isAgentlessEnabled
  } = (0, _app_context.useAppContext)();
  const {
    ingestionStatus,
    isCanceling,
    isSyncing,
    isWaitingForSync
  } = (0, _kea.useValues)((0, _index_view_logic.IndexViewLogic)({
    http
  }));
  const {
    connector,
    hasDocumentLevelSecurityFeature,
    hasIncrementalSyncFeature
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    status
  } = (0, _kea.useValues)(_cancel_syncs_api_logic.CancelSyncsApiLogic);
  const {
    startSync,
    startIncrementalSync,
    startAccessControlSync,
    cancelSyncs
  } = (0, _kea.useActions)((0, _syncs_logic.SyncsLogic)({
    http
  }));
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const togglePopover = () => setPopover(!isPopoverOpen);
  const closePopover = () => setPopover(false);
  const getSyncButtonText = () => {
    if (isWaitingForSync) {
      return _i18n.i18n.translate('xpack.contentConnectors.content.index.syncButton.waitingForSync.label', {
        defaultMessage: 'Waiting for sync'
      });
    }
    if (isSyncing && (connector === null || connector === void 0 ? void 0 : connector.status) !== _searchConnectors.ConnectorStatus.ERROR) {
      return _i18n.i18n.translate('xpack.contentConnectors.content.index.syncButton.syncing.label', {
        defaultMessage: 'Syncing'
      });
    }
    return _i18n.i18n.translate('xpack.contentConnectors.content.index.syncButton.label', {
      defaultMessage: 'Sync'
    });
  };
  const syncLoading = (isSyncing || isWaitingForSync) && ingestionStatus !== _searchConnectors.IngestionStatus.ERROR;
  const isWaitingForConnector = !(connector !== null && connector !== void 0 && connector.status) || (connector === null || connector === void 0 ? void 0 : connector.status) === _searchConnectors.ConnectorStatus.CREATED;
  const shouldShowDocumentLevelSecurity = hasDocumentLevelSecurityFeature;
  const shouldShowIncrementalSync = hasIncrementalSyncFeature;
  const isSyncsDisabled = (connector === null || connector === void 0 ? void 0 : connector.is_native) && !isAgentlessEnabled || ingestionStatus === _searchConnectors.IngestionStatus.INCOMPLETE || !(connector !== null && connector !== void 0 && connector.index_name);
  const panels = [{
    id: 0,
    items: [...(syncLoading ? [] : [{
      // @ts-ignore - data-* attributes are applied but doesn't exist on types
      'data-telemetry-id': `entSearchContent-connector-header-sync-startSync`,
      'data-test-subj': `entSearchContent-connector-header-sync-startSync`,
      disabled: isSyncsDisabled,
      icon: 'play',
      name: _i18n.i18n.translate('xpack.contentConnectors.index.header.more.fullSync', {
        defaultMessage: 'Full Content'
      }),
      onClick: () => {
        closePopover();
        startSync(connector);
      }
    }]), ...(shouldShowIncrementalSync ? [{
      // @ts-ignore - data-* attributes are applied but doesn't exist on types
      'data-telemetry-id': `entSearchContent-connector-header-sync-more-incrementalSync`,
      'data-test-subj': `entSearchContent-connector-header-sync-more-incrementalSync`,
      disabled: isSyncsDisabled,
      icon: 'play',
      name: _i18n.i18n.translate('xpack.contentConnectors.index.header.more.incrementalSync', {
        defaultMessage: 'Incremental Content'
      }),
      onClick: () => {
        closePopover();
        startIncrementalSync(connector);
      }
    }] : []), ...(shouldShowDocumentLevelSecurity ? [{
      // @ts-ignore - data-* attributes are applied but doesn't exist on types
      'data-telemetry-id': `entSearchContent-connector-header-sync-more-accessControlSync`,
      'data-test-subj': `entSearchContent-connector-header-sync-more-accessControlSync`,
      disabled: Boolean(isSyncsDisabled || !(connector !== null && connector !== void 0 && (_connector$configurat = connector.configuration.use_document_level_security) !== null && _connector$configurat !== void 0 && _connector$configurat.value)),
      icon: 'play',
      name: _i18n.i18n.translate('xpack.contentConnectors.index.header.more.accessControlSync', {
        defaultMessage: 'Access Control'
      }),
      onClick: () => {
        closePopover();
        startAccessControlSync(connector);
      }
    }] : []), {
      // @ts-ignore - data-* attributes are applied but doesn't exist on types
      'data-telemetry-id': `entSearchContent-connector-header-sync-cancelSync`,
      disabled: isCanceling && ingestionStatus !== _searchConnectors.IngestionStatus.ERROR || status === _api.Status.LOADING,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "cross",
        size: "m",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 17
        }
      }),
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "danger",
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.contentConnectors.index.header.cancelSyncsTitle', {
        defaultMessage: 'Cancel Syncs'
      }))),
      onClick: () => {
        closePopover();
        cancelSyncs(connector);
      }
    }],
    title: 'Sync'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: disabled || isWaitingForConnector,
      "data-test-subj": "enterpriseSearchSyncsContextMenuButton",
      "data-telemetry-id": "entSearchContent-connector-header-sync-openSyncMenu",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: togglePopover,
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 11
      }
    }, syncLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "entSearchContent-connector-header-sync-menu",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 13
      }
    }, getSyncButtonText()))),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }));
};
exports.SyncsContextMenu = SyncsContextMenu;