"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConsoleTourStepProps = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/main/get_console_tour_step_props.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getConsoleTourStepProps = (stateTourStepProps, actions, tourState) => {
  return stateTourStepProps.map(step => {
    const nextTourStep = () => {
      if (tourState.currentTourStep < 5) {
        actions.incrementStep();
      }
    };
    return {
      step: step.step,
      stepsTotal: step.stepsTotal,
      isStepOpen: step.step === tourState.currentTourStep && tourState.isTourActive,
      title: step.title,
      content: step.content,
      anchorPosition: step.anchorPosition,
      dataTestSubj: step['data-test-subj'],
      maxWidth: step.maxWidth,
      css: step.css,
      onFinish: () => actions.finishTour(false),
      footerAction: step.step === step.stepsTotal ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "success",
        size: "s",
        onClick: () => actions.finishTour(),
        "data-test-subj": "consoleCompleteTourButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('console.tour.completeTourButton', {
        defaultMessage: 'Complete'
      })) : [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        color: "text",
        onClick: () => actions.finishTour(),
        "data-test-subj": "consoleSkipTourButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('console.tour.skipTourButton', {
        defaultMessage: 'Skip tour'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "success",
        size: "s",
        onClick: nextTourStep,
        "data-test-subj": "consoleNextTourStepButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('console.tour.nextStepButton', {
        defaultMessage: 'Next'
      }))]
    };
  });
};
exports.getConsoleTourStepProps = getConsoleTourStepProps;