"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleImport = handleImport;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function handleImport({
  objects
}) {
  const hasObjectsWithIncrementalId = objects.some(obj => obj.attributes.incremental_id !== undefined);
  if (hasObjectsWithIncrementalId) {
    return {
      warnings: [{
        type: 'simple',
        message: 'The `incremental_id` field is not supported on importing.'
      }]
    };
  } else {
    return {};
  }
}