"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVisualizationAttachmentType = void 0;
var _react = _interopRequireDefault(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _visualizations = require("../../../common/constants/visualizations");
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../../client/attachment_framework/types");
var _open_lens_button = require("./open_lens_button");
var _lens_renderer = require("./lens_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/visualizations/attachment.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getOpenLensButton(attachmentId, props) {
  return /*#__PURE__*/_react.default.createElement(_open_lens_button.OpenLensButton, {
    attachmentId: attachmentId,
    attributes: props.attributes,
    timeRange: props.timeRange,
    metadata: props.metadata,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  });
}
const getVisualizationAttachmentActions = (attachmentId, props) => [{
  type: _types.AttachmentActionType.CUSTOM,
  render: () => getOpenLensButton(attachmentId, props),
  isPrimary: false
}];
const LensAttachment = /*#__PURE__*/_react.default.memo(props => {
  const {
    attributes,
    timeRange,
    metadata
  } = props.persistableStateAttachmentState;
  return /*#__PURE__*/_react.default.createElement(_lens_renderer.LensRenderer, {
    attributes: attributes,
    timeRange: timeRange,
    metadata: metadata,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 12
    }
  });
}, (prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.persistableStateAttachmentState, nextProps.persistableStateAttachmentState));
LensAttachment.displayName = 'LensAttachment';
const LensAttachmentRendererLazyComponent = /*#__PURE__*/_react.default.lazy(async () => {
  return {
    default: LensAttachment
  };
});
const getVisualizationAttachmentViewObject = ({
  attachmentId,
  persistableStateAttachmentState
}) => {
  const {
    attributes: lensAttributes,
    timeRange: lensTimeRange
  } = persistableStateAttachmentState;
  return {
    event: i18n.ADDED_VISUALIZATION,
    timelineAvatar: 'lensApp',
    getActions: () => getVisualizationAttachmentActions(attachmentId, {
      attributes: lensAttributes,
      timeRange: lensTimeRange
    }),
    hideDefaultActions: false,
    children: LensAttachmentRendererLazyComponent
  };
};
const getVisualizationAttachmentType = () => ({
  id: _visualizations.LENS_ATTACHMENT_TYPE,
  icon: 'document',
  displayName: 'Visualizations',
  getAttachmentViewObject: getVisualizationAttachmentViewObject,
  getAttachmentRemovalObject: () => ({
    event: i18n.REMOVED_VISUALIZATION
  })
});
exports.getVisualizationAttachmentType = getVisualizationAttachmentType;